/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.pipeline;

class PipelineListNode<T> {
    private final T value;
    private PipelineListNode<T> previous;
    private PipelineListNode<T> next;

    PipelineListNode(T value) {
        this.value = value;
    }

    T getValue() {
        return this.value;
    }

    synchronized PipelineListNode<T> getPrevious() {
        return this.previous;
    }

    synchronized PipelineListNode<T> getNext() {
        return this.next;
    }

    synchronized void remove() {
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
    }

    synchronized void addNext(PipelineListNode<T> nextNode) {
        if (this.next != null) {
            throw new IllegalStateException("this list does not currently support insertions in the middle");
        }
        if (nextNode.previous != null) {
            throw new IllegalStateException("element to be inserted already has a previous value");
        }
        this.next = nextNode;
        nextNode.previous = this;
    }

    public String toString() {
        return "(" + this.value + ")";
    }
}

