/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConcurrentBlockingIterator<T>
implements Iterator<T> {
    private final LinkedBlockingQueue<T> buffer;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile int maxWaitTime;
    private volatile TimeUnit maxWaitTimeUnit;
    private T next;

    public ConcurrentBlockingIterator(int bufferSize, int maxWaitTime, TimeUnit maxWaitTimeUnit) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be greater than zero");
        }
        if (maxWaitTime < 0) {
            throw new IllegalArgumentException("maxWaitTime must not be negative");
        }
        this.buffer = new LinkedBlockingQueue(bufferSize);
        this.maxWaitTime = maxWaitTime;
        this.maxWaitTimeUnit = maxWaitTimeUnit == null ? TimeUnit.MILLISECONDS : maxWaitTimeUnit;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        long waitMillis = this.maxWaitTimeUnit.toMillis(this.maxWaitTime);
        long timeOutWhenMillisAre = System.currentTimeMillis() + waitMillis;
        while ((this.next = this.buffer.poll()) == null) {
            if (this.closed.get()) {
                return false;
            }
            if (System.currentTimeMillis() <= timeOutWhenMillisAre) continue;
            throw new RuntimeException(new TimeoutException("Timed out trying to read from buffer"));
        }
        return true;
    }

    @Override
    public T next() {
        if (this.next == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (this.next != null) : "Unexpected null next";
        T ret = this.next;
        this.next = null;
        return ret;
    }

    public boolean supply(T element, long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (this.closed.get()) {
            throw new IllegalStateException("Cannot supply elements to a closed ConcurrentBlockingIterator");
        }
        Objects.requireNonNull(element);
        return this.buffer.offer(element, timeout, timeUnit);
    }

    public void close() {
        this.closed.set(true);
    }

    public void setMaxWaitTime(int maxWaitTime, TimeUnit maxWaitTimeUnit) {
        if (maxWaitTime < 0) {
            throw new IllegalArgumentException("maxWaitTime must not be negative");
        }
        this.maxWaitTime = maxWaitTime;
        this.maxWaitTimeUnit = maxWaitTimeUnit == null ? TimeUnit.MILLISECONDS : maxWaitTimeUnit;
    }
}

