/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualInternalRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.internal.hash.VirtualHashListener;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class ReconnectHashListener<K extends VirtualKey<? super K>, V extends VirtualValue>
implements VirtualHashListener<K, V> {
    private static final int INITIAL_BATCH_ARRAY_SIZE = 10000;
    private final VirtualDataSource<K, V> dataSource;
    private final long firstLeafPath;
    private final long lastLeafPath;
    private final List<List<VirtualLeafRecord<K, V>>> batchLeaves = new ArrayList<List<VirtualLeafRecord<K, V>>>();
    private final List<List<VirtualInternalRecord>> batchInternals = new ArrayList<List<VirtualInternalRecord>>();
    private List<VirtualLeafRecord<K, V>> rankLeaves;
    private List<VirtualInternalRecord> rankInternals;

    public ReconnectHashListener(long firstLeafPath, long lastLeafPath, VirtualDataSource<K, V> dataSource) {
        if (firstLeafPath != -1L && (firstLeafPath <= 0L || firstLeafPath > lastLeafPath)) {
            throw new IllegalArgumentException("The first leaf path is invalid. firstLeafPath=" + firstLeafPath + ", lastLeafPath=" + lastLeafPath);
        }
        if (lastLeafPath != -1L && lastLeafPath <= 0L) {
            throw new IllegalArgumentException("The last leaf path is invalid. firstLeafPath=" + firstLeafPath + ", lastLeafPath=" + lastLeafPath);
        }
        this.firstLeafPath = firstLeafPath;
        this.lastLeafPath = lastLeafPath;
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    @Override
    public void onBatchStarted() {
        this.batchLeaves.clear();
        this.batchInternals.clear();
    }

    @Override
    public void onRankStarted() {
        this.rankLeaves = new ArrayList<VirtualLeafRecord<K, V>>(10000);
        this.rankInternals = new ArrayList<VirtualInternalRecord>(10000);
    }

    @Override
    public void onInternalHashed(VirtualInternalRecord internal) {
        this.rankInternals.add(internal);
    }

    @Override
    public void onLeafHashed(VirtualLeafRecord<K, V> leaf) {
        this.rankLeaves.add(leaf);
    }

    @Override
    public void onRankCompleted() {
        this.batchLeaves.add(this.rankLeaves);
        this.batchInternals.add(this.rankInternals);
    }

    @Override
    public void onBatchCompleted() {
        Stream<VirtualInternalRecord> sortedDirtyInternals = Stream.of(new VirtualInternalRecord[0]);
        for (int i = this.batchInternals.size() - 1; i >= 0; --i) {
            sortedDirtyInternals = Stream.concat(sortedDirtyInternals, this.batchInternals.get(i).stream());
        }
        Stream sortedDirtyLeaves = Stream.of(new VirtualLeafRecord[0]);
        for (int i = this.batchLeaves.size() - 1; i >= 0; --i) {
            sortedDirtyLeaves = Stream.concat(sortedDirtyLeaves, this.batchLeaves.get(i).stream());
        }
        try {
            this.dataSource.saveRecords(this.firstLeafPath, this.lastLeafPath, sortedDirtyInternals, sortedDirtyLeaves, Stream.empty());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

