/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.common.crypto.CryptoFactory;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.internal.ExpectedLesson;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.datasource.VirtualRecord;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.StateAccessor;
import com.swirlds.virtualmap.internal.merkle.VirtualRootNode;
import com.swirlds.virtualmap.internal.reconnect.BooleanBitSetQueue;
import com.swirlds.virtualmap.internal.reconnect.ConcurrentBitSetQueue;
import com.swirlds.virtualmap.internal.reconnect.VirtualTreeViewBase;
import java.io.IOException;
import java.util.Objects;

public final class VirtualLearnerTreeView<K extends VirtualKey<? super K>, V extends VirtualValue>
extends VirtualTreeViewBase<K, V>
implements LearnerTreeView<Long> {
    private static final int EXPECTED_BIT_SET_INITIAL_CAPACITY = 0x100000;
    private static final Hash NULL_HASH = CryptoFactory.getInstance().getNullHash();
    private final BooleanBitSetQueue expectedNodeAlreadyPresent = new BooleanBitSetQueue(0x100000);
    private final ConcurrentBitSetQueue expectedChildren = new ConcurrentBitSetQueue();
    private final BooleanBitSetQueue expectedOriginalExists = new BooleanBitSetQueue(0x100000);
    private final RecordAccessor<K, V> originalRecords;
    private boolean firstLeaf = true;

    public VirtualLearnerTreeView(VirtualRootNode<K, V> root, RecordAccessor<K, V> originalRecords, StateAccessor originalState, StateAccessor reconnectState) {
        super(root, originalState, reconnectState);
        this.originalRecords = Objects.requireNonNull(originalRecords);
    }

    public boolean isRootOfState() {
        return false;
    }

    public Long getOriginalRoot() {
        return 0L;
    }

    public Hash getNodeHash(Long originalChild) {
        if (originalChild == null) {
            return NULL_HASH;
        }
        this.checkValidNode(originalChild, this.originalState);
        VirtualRecord node = this.originalRecords.findRecord(originalChild);
        if (node == null) {
            throw new MerkleSynchronizationException("Could not find node for path " + originalChild);
        }
        Hash hash = node.getHash();
        if (hash == null) {
            throw new MerkleSynchronizationException("Node found, but hash was null. path=" + originalChild);
        }
        return hash;
    }

    public void expectLessonFor(Long parent, int childIndex, Long original, boolean nodeAlreadyPresent) {
        this.expectedChildren.add(parent == null ? 0L : Path.getChildPath(parent, childIndex));
        this.expectedNodeAlreadyPresent.add(nodeAlreadyPresent);
        this.expectedOriginalExists.add(original != null);
    }

    public ExpectedLesson<Long> getNextExpectedLesson() {
        long child = this.expectedChildren.remove();
        long parent = Path.getParentPath(child);
        int index = Path.isLeft(child) ? 0 : 1;
        Long original = this.expectedOriginalExists.remove() ? Long.valueOf(child) : null;
        boolean nodeAlreadyPresent = this.expectedNodeAlreadyPresent.remove();
        return new ExpectedLesson((Object)parent, index, (Object)original, nodeAlreadyPresent);
    }

    public boolean hasNextExpectedLesson() {
        assert (this.expectedOriginalExists.isEmpty() == this.expectedChildren.isEmpty() && this.expectedChildren.isEmpty() == this.expectedNodeAlreadyPresent.isEmpty()) : "All three should match";
        return !this.expectedOriginalExists.isEmpty();
    }

    public Long deserializeLeaf(SerializableDataInputStream in) throws IOException {
        if (this.firstLeaf) {
            this.root.prepareForFirstLeaf();
            this.firstLeaf = false;
        }
        VirtualLeafRecord leaf = (VirtualLeafRecord)in.readSerializable();
        this.root.handleReconnectLeaf(leaf);
        return leaf.getPath();
    }

    public Long deserializeInternal(SerializableDataInputStream in) throws IOException {
        long node = in.readLong();
        if (node == 0L) {
            long firstLeafPath = in.readLong();
            long lastLeafPath = in.readLong();
            this.reconnectState.setFirstLeafPath(firstLeafPath);
            this.reconnectState.setLastLeafPath(lastLeafPath);
            this.root.prepareReconnectHashing(firstLeafPath, lastLeafPath);
        }
        return node;
    }

    public void initialize() {
    }

    public void close() {
        this.root.endLearnerReconnect();
    }

    public void markForInitialization(Long node) {
    }

    public void releaseNode(Long node) {
    }

    public void setChild(Long parent, int childIndex, Long child) {
    }

    public Long convertMerkleRootToViewType(MerkleNode node) {
        throw new UnsupportedOperationException("Nested virtual maps not supported");
    }
}

