/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.SerializableDataOutputStream;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.common.threading.ThreadConfiguration;
import com.swirlds.logging.LogMarker;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.datasource.VirtualRecord;
import com.swirlds.virtualmap.internal.ConcurrentNodeStatusTracker;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.StateAccessor;
import com.swirlds.virtualmap.internal.merkle.VirtualRootNode;
import com.swirlds.virtualmap.internal.pipeline.VirtualPipeline;
import com.swirlds.virtualmap.internal.reconnect.ConcurrentBitSetQueue;
import com.swirlds.virtualmap.internal.reconnect.VirtualTreeViewBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VirtualTeacherTreeView<K extends VirtualKey<? super K>, V extends VirtualValue>
extends VirtualTreeViewBase<K, V>
implements TeacherTreeView<Long> {
    private static final Logger LOG = LogManager.getLogger(VirtualTeacherTreeView.class);
    private final ConcurrentBitSetQueue handleQueue = new ConcurrentBitSetQueue();
    private final ConcurrentBitSetQueue expectedResponseQueue = new ConcurrentBitSetQueue();
    private final ConcurrentNodeStatusTracker nodeStatusTracker = new ConcurrentNodeStatusTracker(Long.MAX_VALUE);
    private RecordAccessor<K, V> records;
    private final CountDownLatch ready = new CountDownLatch(1);

    public VirtualTeacherTreeView(VirtualRootNode<K, V> root, StateAccessor state, VirtualPipeline pipeline) {
        super(root, state, state);
        new ThreadConfiguration().setRunnable(() -> {
            this.records = (RecordAccessor)pipeline.detachCopy(root, false);
            this.ready.countDown();
        }).setComponent("virtualmap").setThreadName("detacher").build().start();
    }

    public void waitUntilReady() throws InterruptedException {
        this.ready.await();
    }

    public Long getRoot() {
        return 0L;
    }

    public void addToHandleQueue(Long node) {
        this.checkValidNode(node, this.reconnectState);
        this.handleQueue.add(node);
    }

    public Long getNextNodeToHandle() {
        return this.handleQueue.remove();
    }

    public boolean areThereNodesToHandle() {
        return !this.handleQueue.isEmpty();
    }

    public Long getChildAndPrepareForQueryResponse(Long parent, int childIndex) {
        long child = this.getChild(parent, childIndex);
        this.expectedResponseQueue.add(child);
        return child;
    }

    public Long getNodeForNextResponse() {
        return this.expectedResponseQueue.remove();
    }

    public boolean isResponseExpected() {
        return !this.expectedResponseQueue.isEmpty();
    }

    public void registerResponseForNode(Long node, boolean learnerHasNode) {
        ConcurrentNodeStatusTracker.Status status = learnerHasNode ? ConcurrentNodeStatusTracker.Status.KNOWN : ConcurrentNodeStatusTracker.Status.NOT_KNOWN;
        this.nodeStatusTracker.set(node, status);
    }

    public boolean hasLearnerConfirmedFor(Long node) {
        return this.nodeStatusTracker.getStatus(node) == ConcurrentNodeStatusTracker.Status.KNOWN;
    }

    public void serializeLeaf(SerializableDataOutputStream out, Long leaf) throws IOException {
        this.checkValidLeaf(leaf, this.reconnectState);
        VirtualLeafRecord<K, V> leafRecord = this.records.findLeafRecord(leaf, false);
        assert (leafRecord != null) : "Unexpected null leaf record at path=" + leaf;
        out.writeSerializable(leafRecord, true);
    }

    public void serializeInternal(SerializableDataOutputStream out, Long internal) throws IOException {
        this.checkValidInternal(internal, this.reconnectState);
        out.writeLong(internal.longValue());
        if (internal == 0L) {
            out.writeLong(this.reconnectState.getFirstLeafPath());
            out.writeLong(this.reconnectState.getLastLeafPath());
        }
    }

    public List<Hash> getChildHashes(Long parent) {
        this.checkValidInternal(parent, this.reconnectState);
        if (parent > 0L || parent == 0L && this.reconnectState.getLastLeafPath() > 1L) {
            Hash rightHash;
            long leftPath = Path.getLeftChildPath(parent);
            long rightPath = Path.getRightChildPath(parent);
            VirtualRecord leftLeaf = this.records.findRecord(leftPath);
            VirtualRecord rightLeaf = this.records.findRecord(rightPath);
            Hash leftHash = leftLeaf == null ? null : leftLeaf.getHash();
            Hash hash = rightHash = rightLeaf == null ? null : rightLeaf.getHash();
            if (leftHash == null && rightHash == null) {
                throw new MerkleSynchronizationException("Both children had null hashes at paths " + leftPath + " and " + rightPath + " for parent " + parent);
            }
            return Arrays.asList(leftHash, rightHash);
        }
        if (parent == 0L && this.reconnectState.getLastLeafPath() == 1L) {
            Hash leafHash;
            VirtualLeafRecord<K, V> leaf = this.records.findLeafRecord(1L, false);
            Hash hash = leafHash = leaf == null ? null : leaf.getHash();
            if (leafHash == null) {
                throw new MerkleSynchronizationException("Null leaf hash for path = 1");
            }
            return List.of(leafHash);
        }
        if (parent == 0L && this.reconnectState.getLastLeafPath() == -1L) {
            return Collections.emptyList();
        }
        throw new MerkleSynchronizationException("Unexpected parent " + parent);
    }

    public boolean isCustomReconnectRoot(Long node) {
        return node == 0L;
    }

    public void close() {
        try {
            this.waitUntilReady();
            this.records.getDataSource().close();
        }
        catch (IOException e) {
            LOG.error(LogMarker.RECONNECT.getMarker(), "interrupted while attempting to close data source");
        }
        catch (InterruptedException e) {
            LOG.error(LogMarker.RECONNECT.getMarker(), "Failed to close data source properly", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

