/*
 * Decompiled with CFR 0.152.
 */
package com.swoop.alchemy.spark.expressions.hll;

import com.swoop.alchemy.spark.expressions.hll.HyperLogLogBase;
import com.swoop.alchemy.spark.expressions.hll.HyperLogLogBase$;
import com.swoop.alchemy.spark.expressions.hll.HyperLogLogIntersectionCardinality$;
import com.swoop.alchemy.spark.expressions.hll.Implementation;
import com.swoop.alchemy.spark.expressions.hll.Instance;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(sketchL, sketchR[, implName]) - Returns the estimated intersection cardinality of the binary representations produced by\n    HyperLogLog. Computes a merged (unioned) sketch and uses the fact that |A intersect B| = (|A| + |B|) - |A union B|.\n    Returns null if both sketches are null, but 0 if only one is\n  ")
@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0012%\u0001FB\u0001B\u0016\u0001\u0003\u0016\u0004%\te\u0016\u0005\t7\u0002\u0011\t\u0012)A\u00051\"AA\f\u0001BK\u0002\u0013\u0005s\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003Y\u0011!q\u0006A!f\u0001\n\u0003z\u0006\u0002C2\u0001\u0005#\u0005\u000b\u0011\u00021\t\u000b\u0011\u0004A\u0011A3\t\u000b\u0011\u0004A\u0011\u00016\t\u000b\u0011\u0004A\u0011A7\t\u000bI\u0004A\u0011I:\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\t)\u0005\u0001C)\u0003\u000fB\u0011\"!\u0015\u0001\u0003\u0003%\t!a\u0015\t\u0013\u0005m\u0003!%A\u0005\u0002\u0005u\u0003\"CA:\u0001E\u0005I\u0011AA/\u0011%\t)\bAI\u0001\n\u0003\t9\bC\u0005\u0002|\u0001\t\t\u0011\"\u0011\u0002~!I\u0011Q\u0012\u0001\u0002\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003/\u0003\u0011\u0011!C\u0001\u00033C\u0011\"a(\u0001\u0003\u0003%\t%!)\t\u0013\u0005=\u0006!!A\u0005\u0002\u0005E\u0006\"CA[\u0001\u0005\u0005I\u0011IA\\\u000f%\tI\rJA\u0001\u0012\u0003\tYM\u0002\u0005$I\u0005\u0005\t\u0012AAg\u0011\u0019!7\u0004\"\u0001\u0002\\\"I\u0011Q\\\u000e\u0002\u0002\u0013\u0015\u0013q\u001c\u0005\n\u0003C\\\u0012\u0011!CA\u0003GD\u0011\"a;\u001c#\u0003%\t!a\u001e\t\u0013\u000558$!A\u0005\u0002\u0006=\b\"\u0003B\u00017E\u0005I\u0011AA<\u0011%\u0011\u0019aGA\u0001\n\u0013\u0011)A\u0001\u0012IsB,'\u000fT8h\u0019><\u0017J\u001c;feN,7\r^5p]\u000e\u000b'\u000fZ5oC2LG/\u001f\u0006\u0003K\u0019\n1\u0001\u001b7m\u0015\t9\u0003&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&A\u0004bY\u000eDW-\\=\u000b\u00055r\u0013!B:x_>\u0004(\"A\u0018\u0002\u0007\r|Wn\u0001\u0001\u0014\u000f\u0001\u0011\u0004iQ%N'B\u00111GP\u0007\u0002i)\u0011q%\u000e\u0006\u0003m]\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003qe\n1a]9m\u0015\tI#H\u0003\u0002<y\u00051\u0011\r]1dQ\u0016T\u0011!P\u0001\u0004_J<\u0017BA 5\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00024\u0003&\u0011!\t\u000e\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001#H\u001b\u0005)%B\u0001$5\u0003\u001d\u0019w\u000eZ3hK:L!\u0001S#\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u0004\"AS&\u000e\u0003\u0011J!\u0001\u0014\u0013\u0003\u001f!K\b/\u001a:M_\u001edun\u001a\"bg\u0016\u0004\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002O)&\u0011Qk\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u0001Y!\t\u0019\u0014,\u0003\u0002[i\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0011IW\u000e\u001d7\u0016\u0003\u0001\u0004\"AS1\n\u0005\t$#AD%na2,W.\u001a8uCRLwN\\\u0001\u0006S6\u0004H\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0019<\u0007.\u001b\t\u0003\u0015\u0002AQAV\u0004A\u0002aCQ\u0001X\u0004A\u0002aCqAX\u0004\u0011\u0002\u0003\u0007\u0001\rF\u0002gW2DQA\u0016\u0005A\u0002aCQ\u0001\u0018\u0005A\u0002a#BA\u001a8pa\")a+\u0003a\u00011\")A,\u0003a\u00011\")\u0011/\u0003a\u00011\u0006A\u0011.\u001c9m\u001d\u0006lW-\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u001e\t\u0005kv\f\tA\u0004\u0002ww:\u0011qO_\u0007\u0002q*\u0011\u0011\u0010M\u0001\u0007yI|w\u000e\u001e \n\u0003AK!\u0001`(\u0002\u000fA\f7m[1hK&\u0011ap \u0002\u0004'\u0016\f(B\u0001?P!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004o\u0005)A/\u001f9fg&!\u00111BA\u0003\u0005!!\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\u0005\u0011\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005U\u0001c\u0001(\u0002\u0018%\u0019\u0011\u0011D(\u0003\u000f\t{w\u000e\\3b]\u0006!QM^1m)\u0011\ty\"!\n\u0011\u00079\u000b\t#C\u0002\u0002$=\u00131!\u00118z\u0011%\t9#\u0004I\u0001\u0002\u0004\tI#A\u0003j]B,H\u000f\u0005\u0003\u0002,\u00055R\"A\u001b\n\u0007\u0005=RGA\u0006J]R,'O\\1m%><\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011Q\u0007\t\u0005\u0003o\tyD\u0004\u0003\u0002:\u0005m\u0002CA<P\u0013\r\tidT\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00131\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005ur*A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)\u0001,!\u0013\u0002N!1\u00111J\bA\u0002a\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002P=\u0001\r\u0001W\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u001d1\u0017QKA,\u00033BqA\u0016\t\u0011\u0002\u0003\u0007\u0001\fC\u0004]!A\u0005\t\u0019\u0001-\t\u000fy\u0003\u0002\u0013!a\u0001A\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA0U\rA\u0016\u0011M\u0016\u0003\u0003G\u0002B!!\u001a\u0002p5\u0011\u0011q\r\u0006\u0005\u0003S\nY'A\u0005v]\u000eDWmY6fI*\u0019\u0011QN(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002r\u0005\u001d$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003sR3\u0001YA1\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0010\t\u0005\u0003\u0003\u000bY)\u0004\u0002\u0002\u0004*!\u0011QQAD\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0015\u0001\u00026bm\u0006LA!!\u0011\u0002\u0004\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0013\t\u0004\u001d\u0006M\u0015bAAK\u001f\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qDAN\u0011%\tiJFA\u0001\u0002\u0004\t\t*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003G\u0003b!!*\u0002,\u0006}QBAAT\u0015\r\tIkT\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAW\u0003O\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QCAZ\u0011%\ti\nGA\u0001\u0002\u0004\ty\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003+\tI\fC\u0005\u0002\u001ef\t\t\u00111\u0001\u0002 !:\u0001!!0\u0002D\u0006\u0015\u0007cA\u001a\u0002@&\u0019\u0011\u0011\u0019\u001b\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qY\u0001\u0003\u0002*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tW\u0016$8\r\u001b'-AM\\W\r^2i%nc\u0003%[7qY:\u000bW.Z/*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u0015\u001cH/[7bi\u0016$\u0007%\u001b8uKJ\u001cXm\u0019;j_:\u00043-\u0019:eS:\fG.\u001b;zA=4\u0007\u0005\u001e5fA\tLg.\u0019:zAI,\u0007O]3tK:$\u0018\r^5p]N\u0004\u0003O]8ek\u000e,G\r\t2z\u0015\u0001\u0002\u0003\u0005\t%za\u0016\u0014Hj\\4M_\u001et\u0003eQ8naV$Xm\u001d\u0011bA5,'oZ3eA!*h.[8oK\u0012L\u0003e]6fi\u000eD\u0007%\u00198eAU\u001cXm\u001d\u0011uQ\u0016\u0004c-Y2uAQD\u0017\r\u001e\u0011}\u0003\u0002Jg\u000e^3sg\u0016\u001cG\u000f\t\"}Au\u0002\u0003\u0006`!}A-\u0002CP\u0011?*A5\u0002C0\u0011\u0011v]&|g\u000e\t\"}])\u0001\u0003\u0005\t\u0011SKR,(O\\:!]VdG\u000eI5gA\t|G\u000f\u001b\u0011tW\u0016$8\r[3tA\u0005\u0014X\r\t8vY2d\u0003EY;uAA\u0002\u0013N\u001a\u0011p]2L\be\u001c8fA%\u001c(\u0002\t\u0011\u0002E!K\b/\u001a:M_\u001edunZ%oi\u0016\u00148/Z2uS>t7)\u0019:eS:\fG.\u001b;z!\tQ5d\u0005\u0003\u001c\u0003\u001f\u001c\u0006\u0003CAi\u0003/D\u0006\f\u00194\u000e\u0005\u0005M'bAAk\u001f\u00069!/\u001e8uS6,\u0017\u0002BAm\u0003'\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\tY-\u0001\u0005u_N#(/\u001b8h)\t\ty(A\u0003baBd\u0017\u0010F\u0004g\u0003K\f9/!;\t\u000bYs\u0002\u0019\u0001-\t\u000bqs\u0002\u0019\u0001-\t\u000fys\u0002\u0013!a\u0001A\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005E\u0018Q \t\u0006\u001d\u0006M\u0018q_\u0005\u0004\u0003k|%AB(qi&|g\u000e\u0005\u0004O\u0003sD\u0006\fY\u0005\u0004\u0003w|%A\u0002+va2,7\u0007\u0003\u0005\u0002\u0000\u0002\n\t\u00111\u0001g\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u000f\u0001B!!!\u0003\n%!!1BAB\u0005\u0019y%M[3di\u0002")
public class HyperLogLogIntersectionCardinality
extends BinaryExpression
implements ExpectsInputTypes,
CodegenFallback,
HyperLogLogBase,
Serializable {
    private final Expression left;
    private final Expression right;
    private final Implementation impl;

    public static Implementation $lessinit$greater$default$3() {
        return HyperLogLogIntersectionCardinality$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Implementation>> unapply(HyperLogLogIntersectionCardinality hyperLogLogIntersectionCardinality) {
        return HyperLogLogIntersectionCardinality$.MODULE$.unapply(hyperLogLogIntersectionCardinality);
    }

    public static Implementation apply$default$3() {
        return HyperLogLogIntersectionCardinality$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Implementation>, HyperLogLogIntersectionCardinality> tupled() {
        return HyperLogLogIntersectionCardinality$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Implementation, HyperLogLogIntersectionCardinality>>> curried() {
        return HyperLogLogIntersectionCardinality$.MODULE$.curried();
    }

    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$((CodegenFallback)this, (CodegenContext)ctx, (ExprCode)ev);
    }

    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$((ExpectsInputTypes)this);
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    @Override
    public Implementation impl() {
        return this.impl;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BinaryType$[]{BinaryType$.MODULE$, BinaryType$.MODULE$}));
    }

    public DataType dataType() {
        return LongType$.MODULE$;
    }

    public boolean nullable() {
        return this.left().nullable() && this.right().nullable();
    }

    public Object eval(InternalRow input) {
        Long l;
        Object leftValue = this.left().eval(input);
        Object rightValue = this.right().eval(input);
        if (leftValue != null && rightValue != null) {
            Instance leftHLL = this.impl().deserialize((byte[])leftValue);
            Instance rightHLL = this.impl().deserialize((byte[])rightValue);
            long leftCount = leftHLL.cardinality();
            long rightCount = rightHLL.cardinality();
            leftHLL.merge(rightHLL);
            long unionCount = leftHLL.cardinality();
            l = BoxesRunTime.boxToLong((long)package$.MODULE$.max(leftCount + rightCount - unionCount, 0L));
        } else {
            l = leftValue != null || rightValue != null ? BoxesRunTime.boxToLong((long)0L) : null;
        }
        return l;
    }

    public String prettyName() {
        return "hll_intersect_cardinality";
    }

    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public HyperLogLogIntersectionCardinality copy(Expression left, Expression right, Implementation impl) {
        return new HyperLogLogIntersectionCardinality(left, right, impl);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Implementation copy$default$3() {
        return this.impl();
    }

    public String productPrefix() {
        return "HyperLogLogIntersectionCardinality";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = this.impl();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HyperLogLogIntersectionCardinality;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HyperLogLogIntersectionCardinality)) return false;
        boolean bl = true;
        if (!bl) return false;
        HyperLogLogIntersectionCardinality hyperLogLogIntersectionCardinality = (HyperLogLogIntersectionCardinality)x$1;
        Expression expression = this.left();
        Expression expression2 = hyperLogLogIntersectionCardinality.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = hyperLogLogIntersectionCardinality.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Implementation implementation = this.impl();
        Implementation implementation2 = hyperLogLogIntersectionCardinality.impl();
        if (implementation == null) {
            if (implementation2 != null) {
                return false;
            }
        } else if (!implementation.equals(implementation2)) return false;
        if (!hyperLogLogIntersectionCardinality.canEqual(this)) return false;
        return true;
    }

    public HyperLogLogIntersectionCardinality(Expression left, Expression right, Implementation impl) {
        this.left = left;
        this.right = right;
        this.impl = impl;
        ExpectsInputTypes.$init$((ExpectsInputTypes)this);
        CodegenFallback.$init$((CodegenFallback)this);
    }

    public HyperLogLogIntersectionCardinality(Expression left, Expression right) {
        this(left, right, HyperLogLogBase$.MODULE$.resolveImplementation(HyperLogLogBase$.MODULE$.resolveImplementation$default$1()));
    }

    public HyperLogLogIntersectionCardinality(Expression left, Expression right, Expression implName) {
        this(left, right, HyperLogLogBase$.MODULE$.resolveImplementation(implName));
    }
}

