/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.CacheObservers;
import com.swoval.files.CachedDirectory;
import com.swoval.files.CachedDirectoryImpl;
import com.swoval.files.DirectoryRegistries;
import com.swoval.files.DirectoryRegistry;
import com.swoval.files.DirectoryRegistryImpl;
import com.swoval.files.Entries;
import com.swoval.files.Executor;
import com.swoval.files.FileCacheDirectories;
import com.swoval.files.FileCachePendingFiles;
import com.swoval.files.FileTreeDataView;
import com.swoval.files.FileTreeDataViews;
import com.swoval.files.FileTreeRepositoryImpl;
import com.swoval.files.FileTreeViews;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import com.swoval.files.Sleep;
import com.swoval.files.SymlinkWatcher;
import com.swoval.files.TypedPath;
import com.swoval.files.TypedPaths;
import com.swoval.files.UpdatableFileTreeDataView;
import com.swoval.functional.Either;
import com.swoval.functional.Filter;
import com.swoval.functional.Filters;
import com.swoval.logging.Logger;
import com.swoval.logging.Loggers;
import com.swoval.runtime.Platform;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

class FileCacheDirectoryTree<T>
implements FileTreeDataViews.ObservableCache<T>,
FileTreeDataView<T> {
    private final DirectoryRegistry directoryRegistry = new DirectoryRegistryImpl();
    private final Filter<TypedPath> filter;
    private final FileTreeDataViews.Converter<T> converter;
    private final CacheObservers<T> observers = new CacheObservers();
    private final Executor callbackExecutor;
    private final boolean followLinks;
    private final boolean rescanOnDirectoryUpdate;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Logger logger;
    final SymlinkWatcher symlinkWatcher;
    private final FileCacheDirectories<T> directories;
    private final FileCachePendingFiles pendingFiles;
    private final DirectoryRegistry READ_ONLY_DIRECTORY_REGISTRY = new DirectoryRegistry(){

        @Override
        public void close() {
        }

        @Override
        public boolean addDirectory(Path path, int n) {
            return false;
        }

        @Override
        public int maxDepthFor(Path path) {
            return FileCacheDirectoryTree.this.directoryRegistry.maxDepthFor(path);
        }

        @Override
        public Map<Path, Integer> registered() {
            return FileCacheDirectoryTree.this.directoryRegistry.registered();
        }

        @Override
        public void removeDirectory(Path path) {
        }

        @Override
        public boolean acceptPrefix(Path path) {
            return FileCacheDirectoryTree.this.directoryRegistry.acceptPrefix(path);
        }

        @Override
        public boolean accept(Path path) {
            return FileCacheDirectoryTree.this.directoryRegistry.accept(path);
        }
    };

    FileCacheDirectoryTree(FileTreeDataViews.Converter<T> converter, Executor executor, SymlinkWatcher symlinkWatcher, boolean bl) {
        this(converter, executor, symlinkWatcher, bl, Loggers.getLogger());
    }

    FileCacheDirectoryTree(FileTreeDataViews.Converter<T> converter, Executor executor, SymlinkWatcher symlinkWatcher, boolean bl, Logger logger) {
        this(converter, executor, symlinkWatcher, bl, Loggers.getLogger(), null);
    }

    FileCacheDirectoryTree(FileTreeDataViews.Converter<T> converter, Executor executor, SymlinkWatcher symlinkWatcher, boolean bl, Logger logger, Filter<TypedPath> filter) {
        this.converter = converter;
        this.callbackExecutor = executor;
        this.symlinkWatcher = symlinkWatcher;
        this.followLinks = symlinkWatcher != null;
        this.rescanOnDirectoryUpdate = bl;
        this.logger = logger;
        this.filter = DirectoryRegistries.toTypedPathFilter(this.directoryRegistry, filter);
        if (symlinkWatcher != null) {
            final boolean bl2 = System.getProperty("swoval.symlink.debug", "false").equals("true");
            symlinkWatcher.addObserver((FileTreeViews.Observer<? super PathWatchers.Event>)new FileTreeViews.Observer<PathWatchers.Event>(){

                @Override
                public void onError(Throwable throwable) {
                    if (bl2) {
                        throwable.printStackTrace(System.err);
                    }
                }

                @Override
                public void onNext(PathWatchers.Event event) {
                    FileCacheDirectoryTree.this.handleEvent(event);
                }
            });
        }
        ReentrantLock reentrantLock = new ReentrantLock();
        this.pendingFiles = new FileCachePendingFiles(reentrantLock);
        this.directories = new FileCacheDirectories(reentrantLock);
    }

    DirectoryRegistry readOnlyDirectoryRegistry() {
        return this.READ_ONLY_DIRECTORY_REGISTRY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(Path path) {
        Path path2;
        Path path3 = path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        if (this.directories.lock()) {
            try {
                CachedDirectory<T> cachedDirectory;
                this.directoryRegistry.removeDirectory(path2);
                if (!this.directoryRegistry.accept(path2) && (cachedDirectory = this.find(path2)) != null) {
                    if (cachedDirectory.getPath().equals(path2)) {
                        this.directories.remove(path2);
                    } else {
                        cachedDirectory.remove(path2);
                    }
                }
            }
            finally {
                this.directories.unlock();
            }
        }
        if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
            this.logger.debug(this + " unregistered " + path);
        }
    }

    private CachedDirectory<T> find(Path path) {
        CachedDirectory cachedDirectory = null;
        List list = this.directories.values();
        Collections.sort(list, new Comparator<CachedDirectory<T>>(){

            @Override
            public int compare(CachedDirectory<T> cachedDirectory, CachedDirectory<T> cachedDirectory2) {
                return cachedDirectory2.getPath().compareTo(cachedDirectory.getPath());
            }
        });
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && cachedDirectory == null) {
            CachedDirectory cachedDirectory2 = (CachedDirectory)iterator.next();
            if (!path.startsWith(cachedDirectory2.getPath())) continue;
            if (cachedDirectory2.getMaxDepth() == Integer.MAX_VALUE || path.equals(cachedDirectory2.getPath())) {
                cachedDirectory = cachedDirectory2;
                continue;
            }
            int n = cachedDirectory2.getPath().relativize(path).getNameCount() - 1;
            if (n > cachedDirectory2.getMaxDepth()) continue;
            cachedDirectory = cachedDirectory2;
        }
        return cachedDirectory;
    }

    private void runCallbacks(final List<FileTreeRepositoryImpl.Callback> list) {
        if (!list.isEmpty() && !this.closed.get()) {
            this.callbackExecutor.run(new Runnable(){

                @Override
                public void run() {
                    Collections.sort(list);
                    for (FileTreeRepositoryImpl.Callback callback : list) {
                        if (Loggers.shouldLog(FileCacheDirectoryTree.this.logger, Loggers.Level.DEBUG)) {
                            FileCacheDirectoryTree.this.logger.debug(this + " running callback " + callback);
                        }
                        try {
                            callback.run();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEvent(PathWatchers.Event event) {
        if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
            this.logger.debug(this + " received event " + event);
        }
        TypedPath typedPath = event.getTypedPath();
        ArrayList<TypedPath> arrayList = new ArrayList<TypedPath>();
        ArrayList<FileTreeRepositoryImpl.Callback> arrayList2 = new ArrayList<FileTreeRepositoryImpl.Callback>();
        if (!this.closed.get() && this.directories.lock()) {
            CachedDirectory<T> iOException;
            block24: {
                try {
                    Path path = typedPath.getPath();
                    if (typedPath.exists()) {
                        CachedDirectory<T> cachedDirectory2 = this.find(typedPath.getPath());
                        if (cachedDirectory2 != null) {
                            try {
                                boolean cachedDirectory3;
                                iOException = this.followLinks || !typedPath.isSymbolicLink() ? typedPath : TypedPaths.get(typedPath.getPath(), 4);
                                boolean bl = cachedDirectory3 = this.rescanOnDirectoryUpdate || event.getKind().equals(PathWatchers.Event.Kind.Overflow);
                                if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                                    this.logger.debug(this + " updating " + iOException.getPath() + " in " + cachedDirectory2.getTypedPath());
                                }
                                cachedDirectory2.update((TypedPath)((Object)iOException), cachedDirectory3).observe(this.callbackObserver(arrayList2, arrayList));
                            }
                            catch (IOException iOException2) {
                                this.handleDelete(path, arrayList2, arrayList);
                            }
                            break block24;
                        }
                        if (!this.pendingFiles.contains(path)) break block24;
                        if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                            this.logger.debug(this + " found pending file for " + path);
                        }
                        try {
                            try {
                                iOException = this.newCachedDirectory(path, this.directoryRegistry.maxDepthFor(path));
                                if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                                    this.logger.debug(this + " successfully initialiazed directory for " + path);
                                }
                            }
                            catch (NotDirectoryException iOException3) {
                                if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                                    this.logger.debug(this + " unable to initialize directory for " + path);
                                }
                                iOException = this.newCachedDirectory(path, -1);
                            }
                            CachedDirectory<T> cachedDirectory = this.directories.put(path, iOException);
                            if (cachedDirectory != null) {
                                cachedDirectory.close();
                            }
                            this.addCallback(arrayList2, arrayList, iOException.getEntry(), null, iOException.getEntry(), PathWatchers.Event.Kind.Create, null);
                            for (FileTreeDataViews.Entry<T> entry : iOException.listEntries(iOException.getMaxDepth(), Filters.AllPass)) {
                                this.addCallback(arrayList2, arrayList, entry, null, entry, PathWatchers.Event.Kind.Create, null);
                            }
                            break block24;
                        }
                        catch (IOException iOException4) {
                            System.err.println("Caught unexpected io exception handling event for " + path);
                            iOException4.printStackTrace(System.err);
                            this.pendingFiles.add(path);
                            break block24;
                        }
                    }
                    if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                        this.logger.debug(this + " deleting directory for " + path);
                    }
                    this.handleDelete(path, arrayList2, arrayList);
                }
                finally {
                    this.directories.unlock();
                }
            }
            for (TypedPath typedPath2 : arrayList) {
                iOException = typedPath2.getPath();
                if (this.symlinkWatcher == null) continue;
                if (typedPath2.exists()) {
                    try {
                        this.symlinkWatcher.addSymlink((Path)((Object)iOException), this.directoryRegistry.maxDepthFor((Path)((Object)iOException)));
                    }
                    catch (IOException iOException5) {
                        this.observers.onError(iOException5);
                    }
                    continue;
                }
                this.symlinkWatcher.remove((Path)((Object)iOException));
            }
            this.runCallbacks(arrayList2);
        }
    }

    private void handleDelete(Path path, List<FileTreeRepositoryImpl.Callback> list, List<TypedPath> list2) {
        Object object;
        ArrayList<Iterator<Object>> arrayList = new ArrayList<Iterator<Object>>();
        for (Object object2 : new ArrayList(this.directories.values())) {
            if (!path.startsWith(object2.getPath())) continue;
            List<Object> object3 = path.equals(object2.getPath()) ? object2.listEntries(Integer.MAX_VALUE, Filters.AllPass) : new ArrayList();
            object3.addAll(object2.remove(path));
            object = this.directoryRegistry.registered().keySet().iterator();
            while (object.hasNext()) {
                if (!((Path)object.next()).equals(path)) continue;
                this.pendingFiles.add(path);
            }
            if (object2.getPath().equals(path)) {
                this.directories.remove(path);
                object3.add(object2.getEntry());
            }
            arrayList.add(object3.iterator());
        }
        for (Iterator iterator : arrayList) {
            while (iterator.hasNext()) {
                object = Entries.setExists((FileTreeDataViews.Entry)iterator.next(), false);
                if (this.symlinkWatcher != null && object.getTypedPath().isSymbolicLink()) {
                    this.symlinkWatcher.remove(object.getTypedPath().getPath());
                }
                this.addCallback(list, list2, (FileTreeDataViews.Entry<T>)object, (FileTreeDataViews.Entry<T>)object, null, PathWatchers.Event.Kind.Delete, null);
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true) && this.directories.lock()) {
            try {
                this.callbackExecutor.close();
                if (this.symlinkWatcher != null) {
                    this.symlinkWatcher.close();
                }
                this.directories.clear();
                this.observers.close();
                this.directoryRegistry.close();
                this.pendingFiles.clear();
            }
            finally {
                this.directories.unlock();
            }
        }
        if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
            this.logger.debug(this + " was closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CachedDirectory<T> register(Path path, int n, PathWatcher<PathWatchers.Event> pathWatcher) throws IOException {
        Path path2;
        Path path3 = path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        if (this.directoryRegistry.addDirectory(path2, n) && this.directories.lock()) {
            try {
                UpdatableFileTreeDataView<T> updatableFileTreeDataView;
                Either<IOException, Boolean> either = pathWatcher.register(path2, n);
                if (either.isLeft()) {
                    if (Loggers.shouldLog(this.logger, Loggers.Level.WARN)) {
                        this.logger.warn(this + " failed to register " + path2 + " for monitoring");
                    }
                    throw Either.leftProjection(either).getValue();
                }
                ArrayList arrayList = new ArrayList(this.directories.values());
                Collections.sort(arrayList, new Comparator<CachedDirectory<T>>(){

                    @Override
                    public int compare(CachedDirectory<T> cachedDirectory, CachedDirectory<T> cachedDirectory2) {
                        return cachedDirectory.getPath().compareTo(cachedDirectory2.getPath());
                    }
                });
                Iterator iterator = arrayList.iterator();
                UpdatableFileTreeDataView<T> updatableFileTreeDataView2 = null;
                while (iterator.hasNext() && updatableFileTreeDataView2 == null) {
                    updatableFileTreeDataView = (CachedDirectory<T>)iterator.next();
                    if (!path2.startsWith(updatableFileTreeDataView.getPath())) continue;
                    int n2 = updatableFileTreeDataView.getPath().relativize(path2).getNameCount() - 1;
                    if (updatableFileTreeDataView.getMaxDepth() != Integer.MAX_VALUE && updatableFileTreeDataView.getMaxDepth() - n2 <= n) continue;
                    updatableFileTreeDataView2 = updatableFileTreeDataView;
                }
                if (updatableFileTreeDataView2 == null) {
                    try {
                        try {
                            updatableFileTreeDataView = this.newCachedDirectory(path2, n);
                        }
                        catch (NotDirectoryException notDirectoryException) {
                            updatableFileTreeDataView = this.newCachedDirectory(path2, -1);
                        }
                        this.directories.put(path2, updatableFileTreeDataView);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        this.pendingFiles.add(path2);
                        updatableFileTreeDataView = this.newCachedDirectory(path2, -1);
                    }
                } else {
                    updatableFileTreeDataView2.update(TypedPaths.get(path2));
                    updatableFileTreeDataView = updatableFileTreeDataView2;
                }
                this.cleanupDirectories(path2, n);
                if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                    this.logger.debug(this + " registered " + path + " with max depth " + n);
                }
                UpdatableFileTreeDataView<T> updatableFileTreeDataView3 = updatableFileTreeDataView;
                return updatableFileTreeDataView3;
            }
            finally {
                this.directories.unlock();
            }
        }
        return null;
    }

    private void cleanupDirectories(Path path, int n) {
        Object object;
        Iterator iterator = this.directories.values().iterator();
        ArrayList<Path> arrayList = new ArrayList<Path>();
        while (iterator.hasNext()) {
            object = (CachedDirectory)iterator.next();
            if (!object.getPath().startsWith(path) || object.getPath().equals(path)) continue;
            if (n == Integer.MAX_VALUE) {
                arrayList.add(object.getPath());
                continue;
            }
            int n2 = path.relativize(object.getPath()).getNameCount();
            if (n - n2 < object.getMaxDepth()) continue;
            arrayList.add(object.getPath());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.directories.remove(object.next());
        }
    }

    private void addCallback(List<FileTreeRepositoryImpl.Callback> list, List<TypedPath> list2, FileTreeDataViews.Entry<T> entry, final FileTreeDataViews.Entry<T> entry2, final FileTreeDataViews.Entry<T> entry3, final PathWatchers.Event.Kind kind, final IOException iOException) {
        TypedPath typedPath;
        TypedPath typedPath2 = typedPath = entry == null ? null : entry.getTypedPath();
        if (typedPath != null && typedPath.isSymbolicLink() && this.followLinks) {
            list2.add(typedPath);
        }
        list.add(new FileTreeRepositoryImpl.Callback(typedPath == null ? Paths.get("", new String[0]) : typedPath.getPath()){

            @Override
            public void run() {
                try {
                    if (iOException != null) {
                        FileCacheDirectoryTree.this.observers.onError(iOException);
                    } else if (kind.equals(PathWatchers.Event.Kind.Create)) {
                        FileCacheDirectoryTree.this.observers.onCreate(entry3);
                    } else if (kind.equals(PathWatchers.Event.Kind.Delete)) {
                        FileCacheDirectoryTree.this.observers.onDelete(Entries.setExists(entry2, false));
                    } else if (kind.equals(PathWatchers.Event.Kind.Modify)) {
                        FileCacheDirectoryTree.this.observers.onUpdate(entry2, entry3);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    @Override
    public int addObserver(FileTreeViews.Observer<? super FileTreeDataViews.Entry<T>> observer) {
        return this.observers.addObserver(observer);
    }

    @Override
    public void removeObserver(int n) {
        this.observers.removeObserver(n);
    }

    @Override
    public int addCacheObserver(FileTreeDataViews.CacheObserver<T> cacheObserver) {
        return this.observers.addCacheObserver(cacheObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileTreeDataViews.Entry<T>> listEntries(Path path, int n, Filter<? super FileTreeDataViews.Entry<T>> filter) {
        if (this.directories.lock()) {
            try {
                CachedDirectory<T> cachedDirectory = this.find(path);
                if (cachedDirectory == null) {
                    List<FileTreeDataViews.Entry<T>> list = Collections.emptyList();
                    return list;
                }
                if (cachedDirectory.getPath().equals(path) && cachedDirectory.getMaxDepth() == -1) {
                    ArrayList<FileTreeDataViews.Entry<T>> arrayList = new ArrayList<FileTreeDataViews.Entry<T>>();
                    arrayList.add(cachedDirectory.getEntry());
                    ArrayList<FileTreeDataViews.Entry<T>> arrayList2 = arrayList;
                    return arrayList2;
                }
                int n2 = this.directoryRegistry.maxDepthFor(path);
                List<FileTreeDataViews.Entry<T>> list = cachedDirectory.listEntries(path, n2 < n ? n2 : n, filter);
                return list;
            }
            finally {
                this.directories.unlock();
            }
        }
        return Collections.emptyList();
    }

    private FileTreeDataViews.CacheObserver<T> callbackObserver(final List<FileTreeRepositoryImpl.Callback> list, final List<TypedPath> list2) {
        return new FileTreeDataViews.CacheObserver<T>(){

            @Override
            public void onCreate(FileTreeDataViews.Entry<T> entry) {
                FileCacheDirectoryTree.this.addCallback(list, list2, entry, null, entry, PathWatchers.Event.Kind.Create, null);
            }

            @Override
            public void onDelete(FileTreeDataViews.Entry<T> entry) {
                FileCacheDirectoryTree.this.addCallback(list, list2, entry, entry, null, PathWatchers.Event.Kind.Delete, null);
            }

            @Override
            public void onUpdate(FileTreeDataViews.Entry<T> entry, FileTreeDataViews.Entry<T> entry2) {
                FileCacheDirectoryTree.this.addCallback(list, list2, entry, entry, entry2, PathWatchers.Event.Kind.Modify, null);
            }

            @Override
            public void onError(IOException iOException) {
                FileCacheDirectoryTree.this.addCallback(list, list2, null, null, null, PathWatchers.Event.Kind.Error, iOException);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TypedPath> list(Path path, int n, Filter<? super TypedPath> filter) {
        if (this.directories.lock()) {
            try {
                CachedDirectory<T> cachedDirectory = this.find(path);
                if (cachedDirectory == null) {
                    List<TypedPath> list = Collections.emptyList();
                    return list;
                }
                if (cachedDirectory.getPath().equals(path) && cachedDirectory.getMaxDepth() == -1) {
                    ArrayList<TypedPath> arrayList = new ArrayList<TypedPath>();
                    arrayList.add(TypedPaths.getDelegate(cachedDirectory.getPath(), cachedDirectory.getTypedPath()));
                    ArrayList<TypedPath> arrayList2 = arrayList;
                    return arrayList2;
                }
                List<TypedPath> list = cachedDirectory.list(path, n, filter);
                return list;
            }
            finally {
                this.directories.unlock();
            }
        }
        return Collections.emptyList();
    }

    private CachedDirectory<T> newCachedDirectory(Path path, int n) throws IOException {
        int n2 = 1;
        int n3 = 3;
        CachedDirectoryImpl<T> cachedDirectoryImpl = null;
        do {
            try {
                cachedDirectoryImpl = new CachedDirectoryImpl<T>(TypedPaths.get(path), this.converter, n, this.filter, this.followLinks).init();
            }
            catch (NoSuchFileException | NotDirectoryException fileSystemException) {
                throw fileSystemException;
            }
            catch (AccessDeniedException accessDeniedException) {
                if (!Platform.isWin()) continue;
                try {
                    Sleep.sleep(0L);
                }
                catch (InterruptedException interruptedException) {
                    throw accessDeniedException;
                }
            }
        } while (cachedDirectoryImpl == null && ++n2 <= n3);
        if (cachedDirectoryImpl == null) {
            throw new NoSuchFileException(path.toString());
        }
        return cachedDirectoryImpl;
    }
}

