/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.DirectoryRegistry;
import com.swoval.files.LockableMap;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class DirectoryRegistryImpl
implements DirectoryRegistry {
    private final LockableMap<Path, RegisteredDirectory> registeredDirectoriesByPath = new LockableMap(new ConcurrentHashMap());

    DirectoryRegistryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addDirectory(Path path, int n) {
        if (this.registeredDirectoriesByPath.lock()) {
            try {
                RegisteredDirectory registeredDirectory = this.registeredDirectoriesByPath.get(path);
                if (registeredDirectory == null || n > registeredDirectory.maxDepth) {
                    this.registeredDirectoriesByPath.put(path, new RegisteredDirectory(path, n));
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.registeredDirectoriesByPath.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int maxDepthFor(Path path) {
        if (this.registeredDirectoriesByPath.lock()) {
            try {
                int n = Integer.MIN_VALUE;
                for (RegisteredDirectory registeredDirectory : this.registeredDirectoriesByPath.values()) {
                    int n2;
                    int n3;
                    if (!path.startsWith(registeredDirectory.path) || (n3 = registeredDirectory.maxDepth - (n2 = registeredDirectory.path.equals(path) ? 0 : registeredDirectory.path.relativize(path).getNameCount())) <= n) continue;
                    n = n3;
                }
                int n4 = n;
                return n4;
            }
            finally {
                this.registeredDirectoriesByPath.unlock();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Path, Integer> registered() {
        if (this.registeredDirectoriesByPath.lock()) {
            try {
                HashMap<Path, Integer> hashMap = new HashMap<Path, Integer>();
                for (RegisteredDirectory object2 : this.registeredDirectoriesByPath.values()) {
                    hashMap.put(object2.path, object2.maxDepth);
                }
                HashMap<Path, Integer> hashMap2 = hashMap;
                return hashMap2;
            }
            finally {
                this.registeredDirectoriesByPath.unlock();
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public void removeDirectory(Path path) {
        if (this.registeredDirectoriesByPath.lock()) {
            try {
                this.registeredDirectoriesByPath.remove(path);
            }
            finally {
                this.registeredDirectoriesByPath.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acceptImpl(Path path, boolean bl) {
        if (this.registeredDirectoriesByPath.lock()) {
            try {
                boolean bl2 = false;
                Iterator<Map.Entry<Path, RegisteredDirectory>> iterator = this.registeredDirectoriesByPath.iterator();
                while (!bl2 && iterator.hasNext()) {
                    Map.Entry<Path, RegisteredDirectory> entry = iterator.next();
                    RegisteredDirectory registeredDirectory = entry.getValue();
                    Path path2 = entry.getKey();
                    if (bl && path2.startsWith(path)) {
                        bl2 = true;
                        continue;
                    }
                    if (!path.startsWith(path2)) continue;
                    bl2 = registeredDirectory.accept(path);
                }
                boolean bl3 = bl2;
                return bl3;
            }
            finally {
                this.registeredDirectoriesByPath.unlock();
            }
        }
        return false;
    }

    @Override
    public boolean accept(Path path) {
        return this.acceptImpl(path, false);
    }

    @Override
    public boolean acceptPrefix(Path path) {
        return this.acceptImpl(path, true);
    }

    @Override
    public void close() {
        this.registeredDirectoriesByPath.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.registeredDirectoriesByPath.lock()) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("DirectoryRegistry:\n");
                Iterator<RegisteredDirectory> iterator = this.registeredDirectoriesByPath.values().iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append("  ");
                    stringBuilder.append(iterator.next());
                    stringBuilder.append('\n');
                }
                String string = stringBuilder.toString();
                return string;
            }
            finally {
                this.registeredDirectoriesByPath.unlock();
            }
        }
        return "";
    }

    private static class RegisteredDirectory {
        final Path path;
        final int maxDepth;
        final int compMaxDepth;

        RegisteredDirectory(Path path, int n) {
            this.path = path;
            this.maxDepth = n;
            this.compMaxDepth = n == Integer.MAX_VALUE ? n : n + 1;
        }

        public boolean accept(Path path) {
            return path.startsWith(this.path) && (path.equals(this.path) || this.path.relativize(path).getNameCount() <= this.compMaxDepth);
        }

        public String toString() {
            return "RegisteredDirectory(path = " + this.path + ", depth = " + this.maxDepth + ")";
        }
    }
}

