/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.QuickFile;
import com.swoval.files.QuickList;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class FileOps {
    public static final FileFilter AllPass = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return true;
        }

        public String toString() {
            return "AllPass";
        }
    };

    FileOps() {
    }

    public static List<File> list(Path path, boolean bl) throws IOException {
        return FileOps.list(path, bl, AllPass);
    }

    public static List<File> list(Path path, boolean bl, FileFilter fileFilter) throws IOException {
        return FileOps.list(path, bl ? Integer.MAX_VALUE : 0, fileFilter);
    }

    public static List<File> list(Path path, int n, FileFilter fileFilter) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (QuickFile quickFile : QuickList.list(path, n, true)) {
            if (!fileFilter.accept(quickFile.asFile())) continue;
            arrayList.add(quickFile.toFile());
        }
        return arrayList;
    }

    public static List<Path> parts(Path path) {
        Iterator<Path> iterator = path.iterator();
        ArrayList<Path> arrayList = new ArrayList<Path>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }
}

