/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.ISymAuth;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import exceptions.NoConfigException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import model.Token;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.HttpClientBuilderHelper;

public class SymBotAuth
extends APIClient
implements ISymAuth {
    private final Logger logger = LoggerFactory.getLogger(SymBotAuth.class);
    private String sessionToken;
    private String kmToken;
    private SymConfig config;
    private Client sessionAuthClient;
    private Client kmAuthClient;
    private long lastAuthTime = 0L;

    public SymBotAuth(SymConfig config) {
        this.config = config;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBotBuilder(config);
        Client client = clientBuilder.build();
        if (config.getProxyURL() == null) {
            this.sessionAuthClient = client;
            this.kmAuthClient = client;
        } else {
            Client proxyClient;
            this.kmAuthClient = client;
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.property("jersey.config.client.proxy.uri", (Object)config.getProxyURL());
            if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)config.getProxyUsername());
                clientConfig.property("jersey.config.client.proxy.password", (Object)config.getProxyPassword());
            }
            this.sessionAuthClient = proxyClient = clientBuilder.withConfig((Configuration)clientConfig).build();
        }
    }

    public SymBotAuth(SymConfig config, ClientConfig sessionAuthClientConfig, ClientConfig kmAuthClientConfig) {
        this.config = config;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBotBuilder(config);
        this.sessionAuthClient = sessionAuthClientConfig != null ? clientBuilder.withConfig((Configuration)sessionAuthClientConfig).build() : clientBuilder.build();
        this.kmAuthClient = this.kmAuthClient == null ? clientBuilder.withConfig((Configuration)kmAuthClientConfig).build() : clientBuilder.build();
    }

    @Override
    public void authenticate() {
        if (this.lastAuthTime == 0L | System.currentTimeMillis() - this.lastAuthTime > 3000L) {
            this.sessionAuthenticate();
            this.kmAuthenticate();
        } else {
            try {
                this.logger.info("Re-authenticated too fast. Wait 30 seconds to try again.");
                TimeUnit.SECONDS.sleep(30L);
                this.authenticate();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void sessionAuthenticate() {
        if (this.config != null) {
            this.logger.info("Session auth");
            Response response = this.sessionAuthClient.target("https://" + this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort()).path("/sessionauth/v1/authenticate").request(new String[]{"application/json"}).post(null);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, null);
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error, retry authentication in 30 seconds");
                }
                try {
                    TimeUnit.SECONDS.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.sessionAuthenticate();
            } else {
                Token sessionTokenResponseContent = (Token)response.readEntity(Token.class);
                this.sessionToken = sessionTokenResponseContent.getToken();
            }
        } else {
            throw new NoConfigException("Must provide a SymConfig object to authenticate");
        }
    }

    @Override
    public void kmAuthenticate() {
        this.logger.info("KM auth");
        if (this.config != null) {
            Response response = this.kmAuthClient.target("https://" + this.config.getKeyAuthHost() + ":" + this.config.getKeyAuthPort()).path("/keyauth/v1/authenticate").request(new String[]{"application/json"}).post(null);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, null);
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error, retry authentication in 30 seconds");
                }
                try {
                    TimeUnit.SECONDS.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.kmAuthenticate();
            } else {
                Token kmTokenResponseContent = (Token)response.readEntity(Token.class);
                this.kmToken = kmTokenResponseContent.getToken();
            }
        } else {
            try {
                throw new NoConfigException("Must provide a SymConfig object to authenticate");
            }
            catch (NoConfigException e) {
                this.logger.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Override
    public String getKmToken() {
        return this.kmToken;
    }

    @Override
    public void setKmToken(String kmToken) {
        this.kmToken = kmToken;
    }

    @Override
    public void logout() {
        Response response = this.sessionAuthClient.target("https://" + this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort()).path("/sessionauth/v1/logout").request(new String[]{"application/json"}).header("sessionToken", (Object)this.getSessionToken()).post(null);
    }
}

