/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.ISymAuth;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import model.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.JwtHelper;

public class SymBotRSAAuth
extends APIClient
implements ISymAuth {
    private final Logger logger = LoggerFactory.getLogger(SymBotRSAAuth.class);
    private String sessionToken;
    private String kmToken;
    private SymConfig config;
    private String jwt;
    private long lastAuthTime = 0L;

    public SymBotRSAAuth(SymConfig config) {
        this.config = config;
    }

    @Override
    public void authenticate() {
        long expiration = 300000L;
        PrivateKey privateKey = null;
        try {
            privateKey = JwtHelper.parseRSAPrivateKey(new File(this.config.getBotPrivateKeyPath() + this.config.getBotPrivateKeyName()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        if (this.lastAuthTime == 0L | System.currentTimeMillis() - this.lastAuthTime > 3000L) {
            System.out.println("last auth time was" + this.lastAuthTime);
            System.out.println("now is " + System.currentTimeMillis());
            this.jwt = JwtHelper.createSignedJwt(this.config.getBotUsername(), expiration, privateKey);
            this.sessionAuthenticate();
            this.kmAuthenticate();
            this.lastAuthTime = System.currentTimeMillis();
        } else {
            try {
                this.logger.info("Re-authenticated too fast. Wait 30 seconds to try again.");
                TimeUnit.SECONDS.sleep(30L);
                this.authenticate();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void sessionAuthenticate() {
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("token", this.jwt);
        Client client = ClientBuilder.newClient();
        Response response = client.target("https://" + this.config.getPodHost() + ":" + this.config.getPodPort()).path("/login/pubkey/authenticate").request(new String[]{"application/json"}).post(Entity.entity(token, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, null);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error, retry authentication in 30 seconds");
            }
            try {
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.sessionAuthenticate();
        } else {
            this.sessionToken = ((Token)response.readEntity(Token.class)).getToken();
        }
    }

    @Override
    public void kmAuthenticate() {
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("token", this.jwt);
        Client client = ClientBuilder.newClient();
        Response response = client.target("https://" + this.config.getKeyAuthHost() + ":" + this.config.getKeyAuthPort()).path("/relay/pubkey/authenticate").request(new String[]{"application/json"}).post(Entity.entity(token, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, null);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error, retry authentication in 30 seconds");
            }
            try {
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.kmAuthenticate();
        } else {
            this.kmToken = ((Token)response.readEntity(Token.class)).getToken();
        }
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Override
    public String getKmToken() {
        return this.kmToken;
    }

    @Override
    public void setKmToken(String kmToken) {
        this.kmToken = kmToken;
    }

    @Override
    public void logout() {
        Client client = ClientBuilder.newClient();
        Response response = client.target("https://" + this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort()).path("/sessionauth/v1/logout").request(new String[]{"application/json"}).header("sessionToken", (Object)this.getSessionToken()).post(null);
    }
}

