/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.SymOBOUserAuth;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import exceptions.NoConfigException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import model.Token;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.HttpClientBuilderHelper;

public class SymOBOAuth
extends APIClient {
    private final Logger logger = LoggerFactory.getLogger(SymOBOAuth.class);
    private String sessionToken;
    private SymConfig config;
    private Client sessionAuthClient;

    public SymOBOAuth(SymConfig config) {
        this.config = config;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientAppBuilder(config);
        Client client = clientBuilder.build();
        if (config.getProxyURL() == null) {
            this.sessionAuthClient = client;
        } else {
            Client proxyClient;
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.property("jersey.config.client.proxy.uri", (Object)config.getProxyURL());
            if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)config.getProxyUsername());
                clientConfig.property("jersey.config.client.proxy.password", (Object)config.getProxyPassword());
            }
            this.sessionAuthClient = proxyClient = clientBuilder.withConfig((Configuration)clientConfig).build();
        }
    }

    public SymOBOAuth(SymConfig config, ClientConfig sessionAuthClientConfig) {
        this.config = config;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientAppBuilder(config);
        this.sessionAuthClient = sessionAuthClientConfig != null ? clientBuilder.withConfig((Configuration)sessionAuthClientConfig).build() : clientBuilder.build();
    }

    public SymOBOUserAuth getUserAuth(String username) {
        SymOBOUserAuth userAuth = new SymOBOUserAuth(this.config, this.sessionAuthClient, username, this);
        userAuth.authenticate();
        return userAuth;
    }

    public SymOBOUserAuth getUserAuth(Long uid) {
        SymOBOUserAuth userAuth = new SymOBOUserAuth(this.config, this.sessionAuthClient, uid, this);
        userAuth.authenticate();
        return userAuth;
    }

    public void sessionAppAuthenticate() {
        if (this.config != null) {
            this.logger.info("Session app auth");
            Response response = this.sessionAuthClient.target("https://" + this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort()).path("/sessionauth/v1/app/authenticate").request(new String[]{"application/json"}).post(null);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, null);
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error, retry authentication in 30 seconds");
                }
                try {
                    TimeUnit.SECONDS.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.sessionAppAuthenticate();
            } else {
                Token sessionTokenResponseContent = (Token)response.readEntity(Token.class);
                this.sessionToken = sessionTokenResponseContent.getToken();
            }
        } else {
            try {
                throw new NoConfigException("Must provide a SymConfig object to authenticate");
            }
            catch (NoConfigException e) {
                this.logger.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }
}

