/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.ISymAuth;
import authentication.SymOBOAuth;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import java.util.concurrent.TimeUnit;
import javax.mail.MethodNotSupportedException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import model.SessionToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymOBOUserAuth
extends APIClient
implements ISymAuth {
    private final Logger logger = LoggerFactory.getLogger(SymOBOUserAuth.class);
    private String sessionToken;
    private SymConfig config;
    private Client sessionAuthClient;
    private Long uid;
    private String username;
    SymOBOAuth appAuth;

    public SymOBOUserAuth(SymConfig config, Client sessionAuthClient, Long uid, SymOBOAuth appAuth) {
        this.config = config;
        this.sessionAuthClient = sessionAuthClient;
        this.uid = uid;
        this.appAuth = appAuth;
    }

    public SymOBOUserAuth(SymConfig config, Client sessionAuthClient, String username, SymOBOAuth appAuth) {
        this.config = config;
        this.sessionAuthClient = sessionAuthClient;
        this.username = username;
        this.appAuth = appAuth;
    }

    @Override
    public void authenticate() {
        this.sessionAuthenticate();
    }

    @Override
    public void sessionAuthenticate() {
        Response response = null;
        response = this.uid != null ? this.sessionAuthClient.target("https://" + this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort()).path("/sessionauth/v1/app/user/{uid}/authenticate".replace("{uid}", Long.toString(this.uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.appAuth.getSessionToken()).post(null) : this.sessionAuthClient.target("https://" + this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort()).path("/sessionauth/v1/app/username/{username}/authenticate".replace("{username}", this.username)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.appAuth.getSessionToken()).post(null);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, null);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error, retry authentication in 30 seconds");
            }
            try {
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.appAuth.sessionAppAuthenticate();
            this.sessionAuthenticate();
        } else {
            SessionToken session = (SessionToken)response.readEntity(SessionToken.class);
            this.sessionToken = session.getSessionToken();
        }
    }

    @Override
    public void kmAuthenticate() {
        try {
            throw new MethodNotSupportedException("this method is not supported");
        }
        catch (MethodNotSupportedException e) {
            e.printStackTrace();
            this.logger.warn("method is invalid");
            return;
        }
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Override
    public String getKmToken() {
        this.logger.warn("method is invalid");
        return null;
    }

    @Override
    public void setKmToken(String kmToken) {
        try {
            throw new MethodNotSupportedException("this method is not supported");
        }
        catch (MethodNotSupportedException e) {
            e.printStackTrace();
            this.logger.warn("method is invalid");
            return;
        }
    }

    @Override
    public void logout() {
    }
}

