/*
 * Decompiled with CFR 0.152.
 */
package clients;

import authentication.ISymAuth;
import authentication.SymBotAuth;
import clients.ISymClient;
import clients.symphony.api.AdminClient;
import clients.symphony.api.ConnectionsClient;
import clients.symphony.api.DatafeedClient;
import clients.symphony.api.MessagesClient;
import clients.symphony.api.PresenceClient;
import clients.symphony.api.SignalsClient;
import clients.symphony.api.StreamsClient;
import clients.symphony.api.UsersClient;
import configuration.SymConfig;
import exceptions.SymClientException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.NoContentException;
import model.UserInfo;
import org.glassfish.jersey.client.ClientConfig;
import services.DatafeedEventsService;
import utils.HttpClientBuilderHelper;
import utils.SymMessageParser;

public class SymBotClient
implements ISymClient {
    private static SymBotClient botClient;
    private SymConfig config;
    private ISymAuth symBotAuth;
    private DatafeedClient datafeedClient;
    private MessagesClient messagesClient;
    private PresenceClient presenceClient;
    private StreamsClient streamsClient;
    private UsersClient usersClient;
    private ConnectionsClient connectionsClient;
    private DatafeedEventsService datafeedEventsService;
    private SignalsClient signalsClient;
    private UserInfo botUserInfo;
    private Client podClient;
    private Client agentClient;
    private AdminClient adminClient;

    public static SymBotClient initBot(SymConfig config, ISymAuth symBotAuth) {
        if (botClient == null) {
            botClient = new SymBotClient(config, symBotAuth);
            return botClient;
        }
        return botClient;
    }

    private SymBotClient(SymConfig config, ISymAuth symBotAuth, ClientConfig podClientConfig, ClientConfig agentClientConfig) {
        this.config = config;
        this.symBotAuth = symBotAuth;
        this.podClient = ClientBuilder.newClient((Configuration)podClientConfig);
        this.agentClient = ClientBuilder.newClient((Configuration)agentClientConfig);
        try {
            this.botUserInfo = this.getUsersClient().getUserFromEmail(config.getBotEmailAddress(), true);
        }
        catch (NoContentException e) {
            e.printStackTrace();
        }
        catch (SymClientException e) {
            e.printStackTrace();
        }
    }

    private SymBotClient(SymConfig config, ISymAuth symBotAuth) {
        this.config = config;
        this.symBotAuth = symBotAuth;
        if (config.getProxyURL() == null) {
            this.podClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).build();
            this.agentClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).build();
        } else {
            this.agentClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).build();
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.property("jersey.config.client.proxy.uri", (Object)config.getProxyURL());
            if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)config.getProxyUsername());
                clientConfig.property("jersey.config.client.proxy.password", (Object)config.getProxyPassword());
            }
            this.podClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)clientConfig).build();
        }
        try {
            this.botUserInfo = this.getUsersClient().getUserFromEmail(config.getBotEmailAddress(), true);
        }
        catch (NoContentException e) {
            e.printStackTrace();
        }
        catch (SymClientException e) {
            e.printStackTrace();
        }
    }

    public static SymBotClient initBot(SymConfig config, SymBotAuth botAuth, ClientConfig podClientConfig, ClientConfig agentClientConfig) {
        if (botClient == null) {
            botClient = new SymBotClient(config, botAuth, podClientConfig, agentClientConfig);
            return botClient;
        }
        return botClient;
    }

    public UserInfo getBotUserInfo() {
        return this.botUserInfo;
    }

    public DatafeedClient getDatafeedClient() {
        if (this.datafeedClient == null) {
            this.datafeedClient = new DatafeedClient(this);
        }
        return this.datafeedClient;
    }

    @Override
    public SymConfig getConfig() {
        return this.config;
    }

    @Override
    public ISymAuth getSymAuth() {
        return this.symBotAuth;
    }

    @Override
    public MessagesClient getMessagesClient() {
        if (this.messagesClient == null) {
            SymMessageParser.createInstance(this);
            this.messagesClient = new MessagesClient(this);
        }
        return this.messagesClient;
    }

    @Override
    public PresenceClient getPresenceClient() {
        if (this.presenceClient == null) {
            this.presenceClient = new PresenceClient(this);
        }
        return this.presenceClient;
    }

    @Override
    public StreamsClient getStreamsClient() {
        if (this.streamsClient == null) {
            this.streamsClient = new StreamsClient(this);
        }
        return this.streamsClient;
    }

    @Override
    public UsersClient getUsersClient() {
        if (this.usersClient == null) {
            this.usersClient = new UsersClient(this);
        }
        return this.usersClient;
    }

    @Override
    public ConnectionsClient getConnectionsClient() {
        if (this.connectionsClient == null) {
            this.connectionsClient = new ConnectionsClient(this);
        }
        return this.connectionsClient;
    }

    public DatafeedEventsService getDatafeedEventsService() {
        if (this.datafeedEventsService == null) {
            SymMessageParser.createInstance(this);
            this.datafeedEventsService = new DatafeedEventsService(this);
        }
        return this.datafeedEventsService;
    }

    @Override
    public SignalsClient getSignalsClient() {
        if (this.signalsClient == null) {
            this.signalsClient = new SignalsClient(this);
        }
        return this.signalsClient;
    }

    public AdminClient getAdminClient() {
        if (this.adminClient == null) {
            this.adminClient = new AdminClient(this);
        }
        return this.adminClient;
    }

    public void clearBotClient() {
        botClient = null;
    }

    public static SymBotClient getBotClient() {
        return botClient;
    }

    @Override
    public Client getPodClient() {
        return this.podClient;
    }

    @Override
    public Client getAgentClient() {
        return this.agentClient;
    }

    @Override
    public void setPodClient(Client podClient) {
        this.podClient = podClient;
    }

    @Override
    public void setAgentClient(Client agentClient) {
        this.agentClient = agentClient;
    }
}

