/*
 * Decompiled with CFR 0.152.
 */
package clients;

import authentication.ISymAuth;
import authentication.SymOBOUserAuth;
import clients.ISymClient;
import clients.symphony.api.ConnectionsClient;
import clients.symphony.api.MessagesClient;
import clients.symphony.api.PresenceClient;
import clients.symphony.api.SignalsClient;
import clients.symphony.api.StreamsClient;
import clients.symphony.api.UsersClient;
import configuration.SymConfig;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import utils.HttpClientBuilderHelper;

public class SymOBOClient
implements ISymClient {
    private static SymOBOClient oboClient;
    private SymConfig config;
    private SymOBOUserAuth symAuth;
    private MessagesClient messagesClient;
    private PresenceClient presenceClient;
    private StreamsClient streamsClient;
    private UsersClient usersClient;
    private ConnectionsClient connectionsClient;
    private SignalsClient signalsClient;
    private Client podClient;
    private Client agentClient;

    public static SymOBOClient initOBOClient(SymConfig config, SymOBOUserAuth auth) {
        if (oboClient == null) {
            oboClient = new SymOBOClient(config, auth);
            return oboClient;
        }
        return oboClient;
    }

    private SymOBOClient(SymConfig config, SymOBOUserAuth symAuth, ClientConfig podClientConfig, ClientConfig agentClientConfig) {
        this.config = config;
        this.symAuth = symAuth;
        this.podClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)podClientConfig).build();
        this.agentClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)agentClientConfig).build();
    }

    public SymOBOClient(SymConfig config, SymOBOUserAuth symAuth) {
        this.config = config;
        this.symAuth = symAuth;
        if (config.getProxyURL() == null) {
            this.podClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).build();
            this.agentClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).build();
        } else {
            this.agentClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).build();
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.property("jersey.config.client.proxy.uri", (Object)config.getProxyURL());
            if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)config.getProxyUsername());
                clientConfig.property("jersey.config.client.proxy.password", (Object)config.getProxyPassword());
            }
            this.podClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)clientConfig).build();
        }
    }

    @Override
    public SymConfig getConfig() {
        return this.config;
    }

    @Override
    public ISymAuth getSymAuth() {
        return this.symAuth;
    }

    @Override
    public MessagesClient getMessagesClient() {
        if (this.messagesClient == null) {
            this.messagesClient = new MessagesClient(this);
        }
        return this.messagesClient;
    }

    @Override
    public PresenceClient getPresenceClient() {
        if (this.presenceClient == null) {
            this.presenceClient = new PresenceClient(this);
        }
        return this.presenceClient;
    }

    @Override
    public StreamsClient getStreamsClient() {
        if (this.streamsClient == null) {
            this.streamsClient = new StreamsClient(this);
        }
        return this.streamsClient;
    }

    @Override
    public UsersClient getUsersClient() {
        if (this.usersClient == null) {
            this.usersClient = new UsersClient(this);
        }
        return this.usersClient;
    }

    @Override
    public ConnectionsClient getConnectionsClient() {
        if (this.connectionsClient == null) {
            this.connectionsClient = new ConnectionsClient(this);
        }
        return this.connectionsClient;
    }

    @Override
    public SignalsClient getSignalsClient() {
        if (this.signalsClient == null) {
            this.signalsClient = new SignalsClient(this);
        }
        return this.signalsClient;
    }

    @Override
    public Client getPodClient() {
        return this.podClient;
    }

    @Override
    public Client getAgentClient() {
        return this.agentClient;
    }

    @Override
    public void setPodClient(Client podClient) {
        this.podClient = podClient;
    }

    @Override
    public void setAgentClient(Client agentClient) {
        this.agentClient = agentClient;
    }
}

