/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import exceptions.APIClientErrorException;
import exceptions.ForbiddenException;
import exceptions.ServerErrorException;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import javax.ws.rs.core.Response;
import model.ClientError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APIClient {
    private final Logger logger = LoggerFactory.getLogger(APIClient.class);

    protected void handleError(Response response, ISymClient botClient) throws SymClientException {
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SERVER_ERROR) {
            this.logger.error(response.getStatusInfo().getReasonPhrase());
            throw new ServerErrorException(response.getStatusInfo().getReasonPhrase());
        }
        ClientError error = (ClientError)response.readEntity(ClientError.class);
        if (response.getStatus() == 400) {
            this.logger.error("Client error occurred", (Object)error);
            throw new APIClientErrorException(error.getMessage());
        }
        if (response.getStatus() == 401) {
            this.logger.error("User unauthorized, refreshing tokens");
            if (botClient != null) {
                botClient.getSymAuth().authenticate();
            }
            throw new UnauthorizedException(error.getMessage());
        }
        if (response.getStatus() == 403) {
            this.logger.error("Forbidden: Caller lacks necessary entitlement.");
            throw new ForbiddenException(error.getMessage());
        }
    }
}

