/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import model.AdminNewUser;
import model.AdminStreamFilter;
import model.AdminUserAttributes;
import model.AdminUserInfo;
import model.ApplicationEntitlement;
import model.ApplicationEntitlementList;
import model.Avatar;
import model.AvatarList;
import model.FeatureEntitlement;
import model.FeatureEntitlementList;
import model.InboundImportMessageList;
import model.OutboundImportMessageList;
import model.Status;
import model.StringId;
import model.SuppressionResult;
import model.UserInfo;
import model.events.AdminStreamInfoList;
import org.apache.commons.codec.binary.Base64;

public class AdminClient
extends APIClient {
    private ISymClient botClient;

    public AdminClient(ISymClient client) {
        this.botClient = client;
    }

    public InboundImportMessageList importMessages(OutboundImportMessageList messageList) throws SymClientException {
        Response response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v4/message/import").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(Entity.entity((Object)messageList, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.importMessages(messageList);
            }
            return null;
        }
        return (InboundImportMessageList)response.readEntity(InboundImportMessageList.class);
    }

    public SuppressionResult suppressMessage(String id) throws SymClientException {
        Response response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/messagesuppression/{id}/suppress".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(null);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.suppressMessage(id);
            }
            return null;
        }
        return (SuppressionResult)response.readEntity(SuppressionResult.class);
    }

    public AdminStreamInfoList listEnterpriseStreams(AdminStreamFilter filter, int skip, int limit) throws SymClientException {
        Response response;
        AdminStreamInfoList result = null;
        WebTarget builder = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/admin/streams/list");
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        if ((response = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)filter, (String)"application/json"))).getStatus() == 200) {
            result = (AdminStreamInfoList)response.readEntity(AdminStreamInfoList.class);
        }
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.listEnterpriseStreams(filter, skip, limit);
            }
            return null;
        }
        return result;
    }

    public String createIM(List<Long> userIdList) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/im/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(userIdList, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.createIM(userIdList);
            }
            return null;
        }
        String streamId = ((StringId)response.readEntity(StringId.class)).getId();
        return streamId;
    }

    public UserInfo getUser(Long uid) throws NoContentException, SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/admin/user/{uid}".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getUser(uid);
            }
            return null;
        }
        if (response.getStatus() == 204) {
            throw new NoContentException("No user found.");
        }
        UserInfo info = (UserInfo)response.readEntity(UserInfo.class);
        return info;
    }

    public AdminUserInfo createUser(AdminNewUser newUser) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/admin/user/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)newUser, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.createUser(newUser);
            }
            return null;
        }
        return (AdminUserInfo)response.readEntity(AdminUserInfo.class);
    }

    public AdminUserInfo updateUser(Long userId, AdminUserAttributes userAttributes) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/admin/user/{uid}/update".replace("{uid}", Long.toString(userId))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)userAttributes, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.updateUser(userId, userAttributes);
            }
            return null;
        }
        return (AdminUserInfo)response.readEntity(AdminUserInfo.class);
    }

    public List<Avatar> getAvatar(Long uid) throws SymClientException {
        AvatarList avatar = null;
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/avatar".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getAvatar(uid);
            }
            return null;
        }
        if (response.getStatus() == 204) {
            try {
                throw new NoContentException("No user found.");
            }
            catch (NoContentException e) {
                e.printStackTrace();
            }
        } else {
            avatar = (AvatarList)response.readEntity(AvatarList.class);
        }
        return avatar;
    }

    public void updateAvatar(Long userId, String filePath) throws IOException, SymClientException {
        File f = new File(filePath);
        FileInputStream fis = new FileInputStream(f);
        byte[] byteArray = new byte[(int)f.length()];
        fis.read(byteArray);
        String imageString = Base64.encodeBase64String((byte[])byteArray);
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("image", imageString);
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/avatar/update".replace("{uid}", Long.toString(userId))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(input, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                this.updateAvatar(userId, filePath);
            }
        }
    }

    public String getUserStatus(Long uid) throws SymClientException {
        String statusString = null;
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/status".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getUserStatus(uid);
            }
            return null;
        }
        if (response.getStatus() == 204) {
            try {
                throw new NoContentException("No user found.");
            }
            catch (NoContentException e) {
                e.printStackTrace();
            }
        } else {
            Status status = (Status)response.readEntity(Status.class);
            statusString = status.getStatus();
        }
        return statusString;
    }

    public void updateUserStatus(Long uid, String status) throws SymClientException {
        Status statusObj = new Status();
        statusObj.setStatus(status);
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/status/update".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)statusObj, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                this.updateUserStatus(uid, status);
            }
        } else if (response.getStatus() == 204) {
            try {
                throw new NoContentException("No user found.");
            }
            catch (NoContentException e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> listPodFeatures() throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/system/features/list").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.listPodFeatures();
            }
            return null;
        }
        List features = (List)response.readEntity(ArrayList.class);
        return features;
    }

    public List<FeatureEntitlement> getUserFeatures(Long uid) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/features".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getUserFeatures(uid);
            }
            return null;
        }
        List featureEntitlements = (List)response.readEntity(FeatureEntitlementList.class);
        return featureEntitlements;
    }

    public void updateUserFeatures(Long uid, List<FeatureEntitlement> entitlements) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/features/update".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(entitlements, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                this.updateUserFeatures(uid, entitlements);
            }
        }
    }

    public List<ApplicationEntitlement> getUserApplicationEntitlements(Long uid) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/app/entitlement/list".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getUserApplicationEntitlements(uid);
            }
            return null;
        }
        List entitlements = (List)response.readEntity(ApplicationEntitlementList.class);
        return entitlements;
    }

    public List<ApplicationEntitlement> updateUserApplicationEntitlements(Long uid, List<ApplicationEntitlement> entitlementsUpdate) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/app/entitlement/list".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(entitlementsUpdate, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.updateUserApplicationEntitlements(uid, entitlementsUpdate);
            }
            return null;
        }
        List entitlements = (List)response.readEntity(ApplicationEntitlementList.class);
        return entitlements;
    }
}

