/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.SymBotClient;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import model.DatafeedEvent;
import model.DatafeedEventsList;
import model.StringId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatafeedClient
extends APIClient {
    private final Logger logger = LoggerFactory.getLogger(DatafeedClient.class);
    private SymBotClient botClient;
    private SymConfig config;

    public DatafeedClient(SymBotClient client) {
        this.botClient = client;
        this.config = client.getConfig();
    }

    public String createDatafeed() throws SymClientException {
        Response response = this.botClient.getAgentClient().target("https://" + this.config.getAgentHost() + ":" + this.config.getAgentPort()).path("/agent/v4/datafeed/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(null);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.createDatafeed();
            }
            return null;
        }
        StringId datafeedId = (StringId)response.readEntity(StringId.class);
        return datafeedId.getId();
    }

    public List<DatafeedEvent> readDatafeed(String id) throws SymClientException {
        List<DatafeedEvent> datafeedEvents = null;
        Response response = this.botClient.getAgentClient().target("https://" + this.config.getAgentHost() + ":" + this.config.getAgentPort()).path("/agent/v4/datafeed/{id}/read".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).get();
        if (response.getStatus() == 204) {
            datafeedEvents = new ArrayList<DatafeedEvent>();
        } else if (response.getStatus() == 200) {
            datafeedEvents = (List)response.readEntity(DatafeedEventsList.class);
        } else {
            this.handleError(response, this.botClient);
        }
        return datafeedEvents;
    }
}

