/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import model.Attachment;
import model.FileAttachment;
import model.InboundMessage;
import model.InboundMessageList;
import model.InboundShare;
import model.MessageStatus;
import model.OutboundMessage;
import model.OutboundShare;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class MessagesClient
extends APIClient {
    private ISymClient botClient;

    public MessagesClient(ISymClient client) {
        this.botClient = client;
    }

    private InboundMessage sendMessage(String streamId, OutboundMessage message, boolean appendTags) throws SymClientException {
        Entity entity;
        Response response;
        Client httpClient = this.botClient.getAgentClient();
        httpClient.register(MultiPartFeature.class);
        httpClient.register(JacksonFeature.class);
        WebTarget target = httpClient.target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v4/stream/{sid}/message/create".replace("{sid}", streamId));
        Invocation.Builder invocationBuilder = target.request().accept(new String[]{"application/json"});
        invocationBuilder = invocationBuilder.header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        invocationBuilder = invocationBuilder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        String messageContent = null;
        if (appendTags) {
            messageContent = "<messageML>" + message.getMessage() + "</messageML>";
        }
        FormDataMultiPart multiPart = new FormDataMultiPart();
        FormDataContentDisposition contentDispMessage = FormDataContentDisposition.name((String)"message").build();
        multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDispMessage, messageContent));
        if (message.getData() != null) {
            File[] contentDispData = FormDataContentDisposition.name((String)"data").build();
            multiPart.bodyPart((BodyPart)new FormDataBodyPart((FormDataContentDisposition)contentDispData, message.getData()));
        }
        if (message.getAttachment() != null && message.getAttachment().length > 0) {
            for (File file : message.getAttachment()) {
                FormDataContentDisposition contentDisp = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"attachment").fileName(file.getName())).size(file.length())).build();
                multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
            }
        }
        if ((response = invocationBuilder.post(entity = Entity.entity((Object)multiPart, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE))).getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
            return null;
        }
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.sendMessage(streamId, message, appendTags);
            }
            return null;
        }
        return (InboundMessage)response.readEntity(InboundMessage.class);
    }

    public InboundMessage forwardMessage(String streamId, InboundMessage message) throws SymClientException {
        OutboundMessage outboundMessage = new OutboundMessage();
        outboundMessage.setMessage(message.getMessage());
        outboundMessage.setData(message.getData());
        return this.sendMessage(streamId, outboundMessage, false);
    }

    public InboundMessage sendMessage(String streamId, OutboundMessage message) throws SymClientException {
        return this.sendMessage(streamId, message, true);
    }

    public List<InboundMessage> getMessagesFromStream(String streamId, int since, int skip, int limit) throws SymClientException {
        Response response;
        List result = null;
        WebTarget builder = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v4/stream/{sid}/message".replace("{sid}", streamId)).queryParam("since", new Object[]{since});
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        if ((response = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).get()).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getMessagesFromStream(streamId, since, skip, limit);
            }
            return null;
        }
        result = response.getStatus() == 204 ? new ArrayList() : (List)response.readEntity(InboundMessageList.class);
        return result;
    }

    public byte[] getAttachment(String streamId, String attachmentId, String messageId) throws SymClientException {
        Response response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/stream/{sid}/attachment".replace("{sid}", streamId)).queryParam("fileId", new Object[]{attachmentId}).queryParam("messageId", new Object[]{messageId}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getAttachment(streamId, attachmentId, messageId);
            }
            return null;
        }
        return Base64.getDecoder().decode((String)response.readEntity(String.class));
    }

    public List<FileAttachment> getMessageAttachments(InboundMessage message) throws SymClientException {
        ArrayList<FileAttachment> result = new ArrayList<FileAttachment>();
        if (message.getAttachments() != null) {
            for (Attachment attachment : message.getAttachments()) {
                FileAttachment fileAttachment = new FileAttachment();
                fileAttachment.setFileName(attachment.getName());
                fileAttachment.setSize(attachment.getSize());
                fileAttachment.setFileContent(this.getAttachment(message.getStream().getStreamId(), attachment.getId(), message.getMessageId()));
                result.add(fileAttachment);
            }
        }
        return result;
    }

    public MessageStatus getMessageStatus(String messageId) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/message/{mid}/status".replace("{mid}", messageId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getMessageStatus(messageId);
            }
            return null;
        }
        return (MessageStatus)response.readEntity(MessageStatus.class);
    }

    public InboundMessageList messageSearch(Map<String, String> query, int skip, int limit, boolean orderAscending) throws SymClientException, NoContentException {
        Response response;
        InboundMessageList result = null;
        WebTarget builder = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/message/search");
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        if (orderAscending) {
            builder = builder.queryParam("sortDir", new Object[]{"ASC"});
        }
        if ((response = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(Entity.entity(query, (String)"application/json"))).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.messageSearch(query, skip, limit, orderAscending);
            }
            return null;
        }
        if (response.getStatus() == 204) {
            throw new NoContentException("No messages found");
        }
        result = (InboundMessageList)response.readEntity(InboundMessageList.class);
        return result;
    }

    public InboundShare shareContent(String streamId, OutboundShare shareContent) throws SymClientException {
        HashMap<String, OutboundShare> map = new HashMap<String, OutboundShare>();
        map.put("content", shareContent);
        Response response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v3/stream/{sid}/share".replace("{sid}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(Entity.entity(map, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.shareContent(streamId, shareContent);
            }
            return null;
        }
        return (InboundShare)response.readEntity(InboundShare.class);
    }
}

