/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import model.UserPresence;

public class PresenceClient
extends APIClient {
    ISymClient botClient;

    public PresenceClient(ISymClient client) {
        this.botClient = client;
    }

    public UserPresence getUserPresence(Long userId, boolean local) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v3/user/{uid}/presence".replace("{uid}", Long.toString(userId))).queryParam("local", new Object[]{local}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getUserPresence(userId, local);
            }
            return null;
        }
        return (UserPresence)response.readEntity(UserPresence.class);
    }

    public UserPresence setPresence(String status) throws SymClientException {
        Category category = new Category();
        category.setCategory(status);
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/user/presence").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)category, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.setPresence(status);
            }
            return null;
        }
        return (UserPresence)response.readEntity(UserPresence.class);
    }

    public void registerInterestExtUser(List<Long> userIds) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/user/presence/register").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(userIds, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                this.registerInterestExtUser(userIds);
            }
        }
    }

    private class Category {
        private String category;

        private Category() {
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }
    }
}

