/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import model.Signal;
import model.SignalList;
import model.SignalSubscriberList;
import model.SignalSubscriptionResult;

public class SignalsClient
extends APIClient {
    private ISymClient botClient;

    public SignalsClient(ISymClient client) {
        this.botClient = client;
    }

    public List<Signal> listSignals(int skip, int limit) throws SymClientException {
        List<Signal> result;
        Response response;
        WebTarget builder = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/list");
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        if ((response = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).get()).getStatus() == 204) {
            result = new ArrayList<Signal>();
        } else {
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    return this.listSignals(skip, limit);
                }
                return null;
            }
            result = (List)response.readEntity(SignalList.class);
        }
        return result;
    }

    public Signal getSignal(String id) throws SymClientException {
        Response response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/get".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getSignal(id);
            }
            return null;
        }
        return (Signal)response.readEntity(Signal.class);
    }

    public Signal createSignal(Signal signal) throws SymClientException {
        Response response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(Entity.entity((Object)signal, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.createSignal(signal);
            }
            return null;
        }
        return (Signal)response.readEntity(Signal.class);
    }

    public Signal updateSignal(Signal signal) throws SymClientException {
        Response response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/update".replace("{id}", signal.getId())).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(Entity.entity((Object)signal, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.updateSignal(signal);
            }
            return null;
        }
        return (Signal)response.readEntity(Signal.class);
    }

    public void deleteSignal(String id) throws SymClientException {
        Response response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/delete".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(null);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                this.deleteSignal(id);
            }
        }
    }

    public SignalSubscriptionResult subscribeSignal(String id, boolean self, List<Long> uids, boolean pushed) throws SymClientException {
        Response response = self ? this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/subscribe".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(null) : this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/subscribe".replace("{id}", id)).queryParam("pushed", new Object[]{pushed}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(Entity.entity(uids, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                this.subscribeSignal(id, self, uids, pushed);
            }
        }
        return (SignalSubscriptionResult)response.readEntity(SignalSubscriptionResult.class);
    }

    public SignalSubscriptionResult unsubscribeSignal(String id, boolean self, List<Long> uids) throws SymClientException {
        Response response = self ? this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/unsubscribe".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(null) : this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/unsubscribe".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(Entity.entity(uids, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
                return null;
            }
            catch (UnauthorizedException ex) {
                return this.unsubscribeSignal(id, self, uids);
            }
        }
        return (SignalSubscriptionResult)response.readEntity(SignalSubscriptionResult.class);
    }

    public SignalSubscriberList getSignalSubscribers(String id, int skip, int limit) throws SymClientException {
        Response response;
        WebTarget builder = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/v1/signals/{id}/subscribers".replace("{id}", id));
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        if ((response = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).get()).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getSignalSubscribers(id, skip, limit);
            }
            return null;
        }
        return (SignalSubscriberList)response.readEntity(SignalSubscriberList.class);
    }
}

