/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import model.MemberList;
import model.NumericId;
import model.Room;
import model.RoomInfo;
import model.RoomMember;
import model.RoomSearchQuery;
import model.RoomSearchResult;
import model.StreamInfo;
import model.StreamInfoList;
import model.StreamListItem;
import model.StringId;

public class StreamsClient
extends APIClient {
    private ISymClient botClient;

    public StreamsClient(ISymClient client) {
        this.botClient = client;
    }

    public String getUserIMStreamId(Long userId) throws SymClientException {
        ArrayList<Long> userIdList = new ArrayList<Long>();
        userIdList.add(userId);
        return this.getUserListIM(userIdList);
    }

    public String getUserListIM(List<Long> userIdList) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/im/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(userIdList, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getUserListIM(userIdList);
            }
            return null;
        }
        String streamId = ((StringId)response.readEntity(StringId.class)).getId();
        return streamId;
    }

    public RoomInfo createRoom(Room room) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v3/room/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)room, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.createRoom(room);
            }
            return null;
        }
        RoomInfo roomInfo = (RoomInfo)response.readEntity(RoomInfo.class);
        return roomInfo;
    }

    public void addMemberToRoom(String streamId, Long userId) throws SymClientException {
        NumericId id = new NumericId(userId);
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/room/{id}/membership/add".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)id, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                this.addMemberToRoom(streamId, userId);
            }
        }
    }

    public void removeMemberFromRoom(String streamId, Long userId) throws SymClientException {
        NumericId id = new NumericId(userId);
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/room/{id}/membership/remove".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)id, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                this.removeMemberFromRoom(streamId, userId);
            }
        }
    }

    public RoomInfo getRoomInfo(String streamId) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v3/room/{id}/info".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getRoomInfo(streamId);
            }
            return null;
        }
        return (RoomInfo)response.readEntity(RoomInfo.class);
    }

    public RoomInfo updateRoom(String streamId, Room room) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v3/room/{id}/update".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)room, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.updateRoom(streamId, room);
            }
            return null;
        }
        RoomInfo roomInfo = (RoomInfo)response.readEntity(RoomInfo.class);
        return roomInfo;
    }

    public StreamInfo getStreamInfo(String streamId) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/streams/{id}/info".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getStreamInfo(streamId);
            }
            return null;
        }
        return (StreamInfo)response.readEntity(StreamInfo.class);
    }

    public List<RoomMember> getRoomMembers(String streamId) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/room/{id}/membership/list".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getRoomMembers(streamId);
            }
            return null;
        }
        return (List)response.readEntity(MemberList.class);
    }

    public void activateRoom(String streamId) throws SymClientException {
        this.setActiveRoom(streamId, true);
    }

    public void deactivateRoom(String streamId) throws SymClientException {
        this.setActiveRoom(streamId, false);
    }

    private void setActiveRoom(String streamId, boolean active) throws SymClientException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/room/{id}/setActive".replace("{id}", streamId)).queryParam("active", new Object[]{active}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(null);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                this.setActiveRoom(streamId, active);
            }
        }
    }

    public void promoteUserToOwner(String streamId, Long userId) throws SymClientException {
        NumericId id = new NumericId(userId);
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/room/{id}/membership/promoteOwner".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)id, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                this.promoteUserToOwner(streamId, userId);
            }
        }
    }

    public void demoteUserFromOwner(String streamId, Long userId) throws SymClientException {
        NumericId id = new NumericId(userId);
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/room/{id}/membership/demoteOwner".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)id, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                this.demoteUserFromOwner(streamId, userId);
            }
        }
    }

    public RoomSearchResult searchRooms(RoomSearchQuery query, int skip, int limit) throws SymClientException, NoContentException {
        Response response;
        RoomSearchResult result = null;
        WebTarget builder = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v3/room/search");
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        if (query.getLabels() == null) {
            query.setLabels(new ArrayList<String>());
        }
        if ((response = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)query, (String)"application/json"))).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.searchRooms(query, skip, limit);
            }
            return null;
        }
        if (response.getStatus() == 204) {
            throw new NoContentException("No messages found");
        }
        result = (RoomSearchResult)response.readEntity(RoomSearchResult.class);
        return result;
    }

    public List<StreamListItem> getUserStreams(List<String> streamTypes, boolean includeInactiveStreams) throws SymClientException {
        ArrayList inputStreamTypes = new ArrayList();
        if (streamTypes != null) {
            for (String type : streamTypes) {
                HashMap<String, String> streamTypesMap = new HashMap<String, String>();
                streamTypesMap.put("type", type);
                inputStreamTypes.add(streamTypesMap);
            }
        }
        HashMap<String, Serializable> input = new HashMap<String, Serializable>();
        input.put("streamTypes", inputStreamTypes);
        input.put("includeInactiveStreams", Boolean.valueOf(includeInactiveStreams));
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/streams/list").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(input, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getUserStreams(streamTypes, includeInactiveStreams);
            }
            return null;
        }
        return (List)response.readEntity(StreamInfoList.class);
    }

    public StreamListItem getUserWallStream() throws SymClientException {
        ArrayList<String> streamTypes = new ArrayList<String>();
        streamTypes.add("POST");
        return this.getUserStreams(streamTypes, false).get(0);
    }
}

