/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import model.UserFilter;
import model.UserInfo;
import model.UserInfoList;
import model.UserSearchResult;

public class UsersClient
extends APIClient {
    private ISymClient botClient;

    public UsersClient(ISymClient client) {
        this.botClient = client;
    }

    public UserInfo getUserFromUsername(String username) throws SymClientException, NoContentException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/user").queryParam("username", new Object[]{username}).queryParam("local", new Object[]{true}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getUserFromUsername(username);
            }
            return null;
        }
        if (response.getStatus() == 204) {
            throw new NoContentException("No user found.");
        }
        UserInfo info = (UserInfo)response.readEntity(UserInfo.class);
        return info;
    }

    public UserInfo getUserFromEmail(String email, Boolean local) throws SymClientException, NoContentException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v3/users").queryParam("email", new Object[]{email}).queryParam("local", new Object[]{local}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getUserFromEmail(email, local);
            }
            return null;
        }
        if (response.getStatus() == 204) {
            throw new NoContentException("No user found.");
        }
        UserInfoList infoList = (UserInfoList)response.readEntity(UserInfoList.class);
        UserInfo info = infoList.getUsers().get(0);
        return info;
    }

    public UserInfo getUserFromId(Long id, Boolean local) throws SymClientException, NoContentException {
        Response response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v3/users").queryParam("uid", new Object[]{id}).queryParam("local", new Object[]{local}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getUserFromId(id, local);
            }
            return null;
        }
        if (response.getStatus() == 204) {
            throw new NoContentException("No user found.");
        }
        UserInfoList infoList = (UserInfoList)response.readEntity(UserInfoList.class);
        UserInfo info = infoList.getUsers().get(0);
        return info;
    }

    public List<UserInfo> getUsersFromIdList(List<Long> idList, Boolean local) throws SymClientException, NoContentException {
        return this.getUsersV3(null, idList, local);
    }

    public List<UserInfo> getUsersFromEmailList(List<String> emailList, Boolean local) throws SymClientException, NoContentException {
        return this.getUsersV3(emailList, null, local);
    }

    public List<UserInfo> getUsersV3(List<String> emailList, List<Long> idList, Boolean local) throws SymClientException, NoContentException {
        Response response;
        int i;
        List<UserInfo> infoList = new ArrayList<UserInfo>();
        boolean emailBased = false;
        StringBuilder lookUpListString = new StringBuilder();
        if (emailList != null) {
            if (emailList.isEmpty()) {
                throw new NoContentException("No user sent for lookup");
            }
            emailBased = true;
            lookUpListString.append(emailList.get(0));
            for (i = 1; i < emailList.size(); ++i) {
                lookUpListString.append("," + emailList.get(i));
            }
        } else if (idList != null) {
            if (idList.isEmpty()) {
                throw new NoContentException("No user sent for lookup");
            }
            lookUpListString.append(idList.get(0));
            for (i = 1; i < idList.size(); ++i) {
                lookUpListString.append("," + idList.get(i));
            }
        } else {
            throw new NoContentException("No user sent for lookup");
        }
        if ((response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v3/users").queryParam(emailBased ? "email" : "uid", new Object[]{lookUpListString.toString()}).queryParam("local", new Object[]{local}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get()).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.getUsersV3(emailList, idList, local);
            }
            return null;
        }
        if (response.getStatus() == 204) {
            return infoList;
        }
        UserInfoList userInfo = (UserInfoList)response.readEntity(UserInfoList.class);
        infoList = userInfo.getUsers();
        return infoList;
    }

    public UserSearchResult searchUsers(String query, boolean local, int skip, int limit, UserFilter filter) throws SymClientException, NoContentException {
        UserSearchResult result = null;
        WebTarget builder = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/user/search");
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        if (local) {
            builder = builder.queryParam("local", new Object[]{local});
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("query", query);
        body.put("filters", filter);
        Response response = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(body, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, this.botClient);
            }
            catch (UnauthorizedException ex) {
                return this.searchUsers(query, local, skip, limit, filter);
            }
            return null;
        }
        if (response.getStatus() == 204) {
            throw new NoContentException("No user found");
        }
        result = (UserSearchResult)response.readEntity(UserSearchResult.class);
        return result;
    }
}

