/*
 * Decompiled with CFR 0.152.
 */
package services;

import clients.SymBotClient;
import clients.symphony.api.DatafeedClient;
import exceptions.SymClientException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import listeners.ConnectionListener;
import listeners.IMListener;
import listeners.RoomListener;
import model.DatafeedEvent;
import model.events.MessageSent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatafeedEventsService {
    private final Logger logger = LoggerFactory.getLogger(DatafeedEventsService.class);
    private SymBotClient botClient;
    private DatafeedClient datafeedClient;
    private List<RoomListener> roomListeners;
    private List<IMListener> IMListeners;
    private List<ConnectionListener> connectionListeners;
    private String datafeedId;
    private ExecutorService pool;
    private AtomicBoolean stop = new AtomicBoolean();

    public DatafeedEventsService(SymBotClient client) {
        this.botClient = client;
        this.roomListeners = new ArrayList<RoomListener>();
        this.IMListeners = new ArrayList<IMListener>();
        this.connectionListeners = new ArrayList<ConnectionListener>();
        this.datafeedClient = this.botClient.getDatafeedClient();
        this.datafeedId = this.datafeedClient.createDatafeed();
        this.readDatafeed();
        this.stop.set(false);
    }

    public void addRoomListener(RoomListener listener) {
        this.roomListeners.add(listener);
    }

    public void removeRoomListener(RoomListener listener) {
        this.roomListeners.remove(listener);
    }

    public void addIMListener(IMListener listener) {
        this.IMListeners.add(listener);
    }

    public void removeIMListener(IMListener listener) {
        this.IMListeners.remove(listener);
    }

    public void addConnectionsListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionsListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public void readDatafeed() {
        if (this.pool != null) {
            this.pool.shutdown();
        }
        this.pool = Executors.newFixedThreadPool(5);
        CompletableFuture.supplyAsync(() -> {
            while (!this.stop.get()) {
                CompletionStage future = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    try {
                        return this.datafeedClient.readDatafeed(this.datafeedId);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, this.pool).exceptionally(ex -> {
                    this.handleError((Throwable)ex);
                    return null;
                })).thenApply(events -> {
                    if (!events.isEmpty()) {
                        this.handleEvents((List<DatafeedEvent>)events);
                    }
                    return null;
                });
                try {
                    ((CompletableFuture)future).get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }, this.pool);
    }

    public void stopDatafeedService() {
        if (!this.stop.get()) {
            this.stop.set(true);
        }
    }

    public void restartDatafeedService() {
        if (this.stop.get()) {
            this.stop.set(false);
        }
        this.datafeedId = this.datafeedClient.createDatafeed();
        this.readDatafeed();
    }

    private void handleError(Throwable e) {
        this.logger.error(e.getMessage());
        try {
            TimeUnit.SECONDS.sleep(30L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        try {
            this.datafeedId = this.datafeedClient.createDatafeed();
        }
        catch (SymClientException e1) {
            try {
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            this.handleError(e);
        }
    }

    private void handleEvents(List<DatafeedEvent> datafeedEvents) {
        block28: for (DatafeedEvent event : datafeedEvents) {
            if (event.getInitiator().getUser().getUserId().equals(this.botClient.getBotUserInfo().getId())) continue;
            switch (event.getType()) {
                case "MESSAGESENT": {
                    MessageSent messageSent = event.getPayload().getMessageSent();
                    if (messageSent.getMessage().getStream().getStreamType().equals("ROOM")) {
                        for (RoomListener roomListener : this.roomListeners) {
                            roomListener.onRoomMessage(messageSent.getMessage());
                        }
                        continue block28;
                    }
                    for (IMListener iMListener : this.IMListeners) {
                        iMListener.onIMMessage(messageSent.getMessage());
                    }
                    continue block28;
                }
                case "INSTANTMESSAGECREATED": {
                    for (IMListener iMListener : this.IMListeners) {
                        iMListener.onIMCreated(event.getPayload().getInstantMessageCreated().getStream());
                    }
                    continue block28;
                }
                case "ROOMCREATED": {
                    for (RoomListener roomListener : this.roomListeners) {
                        roomListener.onRoomCreated(event.getPayload().getRoomCreated());
                    }
                    continue block28;
                }
                case "ROOMUPDATED": {
                    for (RoomListener roomListener : this.roomListeners) {
                        roomListener.onRoomUpdated(event.getPayload().getRoomUpdated());
                    }
                    continue block28;
                }
                case "ROOMDEACTIVATED": {
                    for (RoomListener roomListener : this.roomListeners) {
                        roomListener.onRoomDeactivated(event.getPayload().getRoomDeactivated());
                    }
                    continue block28;
                }
                case "ROOMREACTIVATED": {
                    for (RoomListener roomListener : this.roomListeners) {
                        roomListener.onRoomReactivated(event.getPayload().getRoomReactivated().getStream());
                    }
                    continue block28;
                }
                case "USERJOINEDROOM": {
                    for (RoomListener roomListener : this.roomListeners) {
                        roomListener.onUserJoinedRoom(event.getPayload().getUserJoinedRoom());
                    }
                    continue block28;
                }
                case "USERLEFTROOM": {
                    for (RoomListener roomListener : this.roomListeners) {
                        roomListener.onUserLeftRoom(event.getPayload().getUserLeftRoom());
                    }
                    continue block28;
                }
                case "ROOMMEMBERPROMOTEDTOOWNER": {
                    for (RoomListener roomListener : this.roomListeners) {
                        roomListener.onRoomMemberPromotedToOwner(event.getPayload().getRoomMemberPromotedToOwner());
                    }
                    continue block28;
                }
                case "ROOMMEMBERDEMOTEDFROMOWNER": {
                    for (RoomListener roomListener : this.roomListeners) {
                        roomListener.onRoomMemberDemotedFromOwner(event.getPayload().getRoomMemberDemotedFromOwner());
                    }
                    continue block28;
                }
                case "CONNECTIONACCEPTED": {
                    for (ConnectionListener connectionListener : this.connectionListeners) {
                        connectionListener.onConnectionAccepted(event.getPayload().getConnectionAccepted().getFromUser());
                    }
                    continue block28;
                }
                case "CONNECTIONREQUESTED": {
                    for (ConnectionListener connectionListener : this.connectionListeners) {
                        connectionListener.onConnectionRequested(event.getPayload().getConnectionRequested().getToUser());
                    }
                    continue block28;
                }
            }
        }
    }
}

