/*
 * Decompiled with CFR 0.152.
 */
package utils;

import clients.SymBotClient;
import exceptions.SymClientException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.NoContentException;
import model.UserInfo;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.IDataProvider;
import org.symphonyoss.symphony.messageml.util.IUserPresentation;
import utils.UserPresentation;

public class DataProvider
implements IDataProvider {
    private static final Set<String> STANDARD_URI_SCHEMES = new HashSet<String>();
    private UserPresentation user;
    private SymBotClient botClient;

    public DataProvider(SymBotClient botClient) {
        STANDARD_URI_SCHEMES.add("http");
        STANDARD_URI_SCHEMES.add("https");
        this.botClient = botClient;
    }

    public IUserPresentation getUserPresentation(String email) throws InvalidInputException {
        if (!email.equalsIgnoreCase(this.user.getEmail())) {
            throw new InvalidInputException("Failed to lookup user \"" + email + "\"");
        }
        return new UserPresentation(this.user.getId(), this.user.getScreenName(), this.user.getPrettyName(), email);
    }

    public IUserPresentation getUserPresentation(Long uid) throws InvalidInputException {
        UserInfo userInfo = null;
        try {
            userInfo = this.botClient.getUsersClient().getUserFromId(uid, false);
        }
        catch (SymClientException e) {
            e.printStackTrace();
        }
        catch (NoContentException e) {
            e.printStackTrace();
        }
        return new UserPresentation(uid, userInfo.getDisplayName(), userInfo.getDisplayName());
    }

    public void validateURI(URI uri) throws InvalidInputException {
        if (!STANDARD_URI_SCHEMES.contains(uri.getScheme().toLowerCase())) {
            throw new InvalidInputException("URI scheme \"" + uri.getScheme() + "\" is not supported by the pod.");
        }
    }

    public void setUserPresentation(UserPresentation user) {
        this.user = user;
    }

    public void setUserPresentation(long id, String screenName, String prettyName, String email) {
        this.user = new UserPresentation(id, screenName, prettyName, email);
    }
}

