/*
 * Decompiled with CFR 0.152.
 */
package utils;

import clients.SymBotClient;
import java.io.IOException;
import java.util.regex.Pattern;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.util.IDataProvider;
import utils.DataProvider;

public class SymMessageParser {
    static final String regex = "(\\<div.*\\>)(.*)(\\<\\/div\\>)";
    static final Pattern pattern = Pattern.compile("(\\<div.*\\>)(.*)(\\<\\/div\\>)");
    private static SymMessageParser instance;
    private SymBotClient botClient;

    protected SymMessageParser(SymBotClient botClient) {
        this.botClient = botClient;
    }

    public static SymMessageParser getInstance() {
        if (instance != null) {
            return instance;
        }
        try {
            throw new Exception("SymMessageParser needs to be initialized at startup");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SymMessageParser createInstance(SymBotClient botClient) {
        if (instance == null) {
            instance = new SymMessageParser(botClient);
            return instance;
        }
        return instance;
    }

    public String messageToText(String message, String entityJSON) {
        MessageMLContext context = new MessageMLContext((IDataProvider)new DataProvider(this.botClient));
        try {
            context.parseMessageML(message, entityJSON, "2.0");
            return context.getText();
        }
        catch (InvalidInputException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ProcessingException e) {
            e.printStackTrace();
        }
        return null;
    }
}

