/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.ISymExtensionAppAuth;
import authentication.extensionapp.InMemoryTokensRepository;
import authentication.extensionapp.TokensRepository;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import exceptions.NoConfigException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import model.AppAuthResponse;
import model.PodCert;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSymExtensionAppAuth
extends APIClient
implements ISymExtensionAppAuth {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSymExtensionAppAuth.class);
    private final SecureRandom secureRandom = new SecureRandom();
    protected final SymConfig config;
    protected Client sessionAuthClient;
    protected final TokensRepository tokensRepository;
    private int authRetries = 0;

    protected AbstractSymExtensionAppAuth(SymConfig config) {
        this.config = config;
        this.tokensRepository = new InMemoryTokensRepository();
    }

    protected AbstractSymExtensionAppAuth(SymConfig config, TokensRepository tokensRepository) {
        this.config = config;
        this.tokensRepository = tokensRepository;
    }

    protected String generateToken() {
        byte[] randBytes = new byte[64];
        this.secureRandom.nextBytes(randBytes);
        return Hex.encodeHexString((byte[])randBytes);
    }

    protected AppAuthResponse handleSessionAppAuthFailure(Response response, String appToken, String ... podSessionAuthUrl) {
        try {
            this.handleError(response, null);
        }
        catch (Exception e) {
            logger.error("Unexpected error, retry authentication in {} seconds", (Object)30);
        }
        try {
            TimeUnit.SECONDS.sleep(30L);
        }
        catch (InterruptedException e) {
            logger.error("Error with authentication", (Throwable)e);
        }
        if (this.authRetries++ > 5) {
            logger.error("Max retries reached. Giving up on auth.");
            return null;
        }
        return this.sessionAppAuthenticate(appToken, podSessionAuthUrl);
    }

    protected String formattedPodSessionAuthUrl(String ... podSessionAuthUrl) {
        String formattedUrl;
        if (podSessionAuthUrl.length == 0 || podSessionAuthUrl[0] == null || StringUtils.isBlank((CharSequence)podSessionAuthUrl[0])) {
            if (this.config == null) {
                throw new NoConfigException("Must provide a SymConfig object to authenticate");
            }
            formattedUrl = this.config.getSessionAuthUrl();
        } else {
            formattedUrl = "https://" + podSessionAuthUrl[0];
        }
        return formattedUrl;
    }

    protected String getPodCertificateFromCertPath(String podCertPath, String ... podSessionAuthUrl) {
        int nbRetries = 0;
        String target = this.formattedPodSessionAuthUrl(podSessionAuthUrl);
        String podCertificate = null;
        do {
            Response response;
            if ((response = this.sessionAuthClient.target(target).path(podCertPath).request(new String[]{"application/json"}).get()).getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                podCertificate = ((PodCert)response.readEntity(PodCert.class)).getCertificate();
                break;
            }
            try {
                this.handleError(response, null);
            }
            catch (Exception e) {
                logger.error("Unexpected error, retry authentication in 30 seconds");
            }
            try {
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException e) {
                logger.error("Error with verify", (Throwable)e);
            }
        } while (++nbRetries < 5);
        if (podCertificate == null) {
            logger.error("Max retries reached but no podCertificate was retrieved. Giving up on getting pod certificate.");
        }
        return podCertificate;
    }
}

