/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.ISymAuth;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import exceptions.AuthenticationException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import model.Token;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.HttpClientBuilderHelper;

public final class SymBotAuth
extends APIClient
implements ISymAuth {
    private final Logger logger = LoggerFactory.getLogger(SymBotAuth.class);
    private String sessionToken = null;
    private String kmToken = null;
    private SymConfig config;
    private Client sessionAuthClient;
    private Client kmAuthClient;
    private long lastAuthTime = 0L;
    private int authRetries = 0;
    private int timeout = 30;
    private int maxAuthRetries = 5;

    public SymBotAuth(SymConfig config) {
        Client client;
        this.config = config;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBotBuilder(config);
        this.sessionAuthClient = client = clientBuilder.build();
        this.kmAuthClient = client;
        this.sessionAuthClient = clientBuilder.withConfig((Configuration)HttpClientBuilderHelper.getPodClientConfig(config)).build();
        this.kmAuthClient = clientBuilder.withConfig((Configuration)HttpClientBuilderHelper.getKMClientConfig(config)).build();
    }

    public SymBotAuth(SymConfig inputConfig, ClientConfig sessionAuthClientConfig, ClientConfig kmAuthClientConfig) {
        this.logger.info("SymBotAuth with ClientConfig variables");
        this.config = inputConfig;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBotBuilder(this.config);
        this.sessionAuthClient = sessionAuthClientConfig != null ? clientBuilder.withConfig((Configuration)sessionAuthClientConfig).build() : clientBuilder.build();
        this.kmAuthClient = kmAuthClientConfig != null ? clientBuilder.withConfig((Configuration)kmAuthClientConfig).build() : clientBuilder.build();
    }

    protected SymBotAuth(SymConfig config, int timeout, int maxAuthRetries) {
        this(config);
        this.timeout = timeout;
        this.maxAuthRetries = maxAuthRetries;
    }

    @Override
    public void authenticate() throws AuthenticationException {
        if (this.lastAuthTime == 0L || System.currentTimeMillis() - this.lastAuthTime > 3000L) {
            this.sessionAuthenticate();
            this.kmAuthenticate();
            this.lastAuthTime = System.currentTimeMillis();
        } else {
            try {
                this.logger.info("Re-authenticated too fast. Wait 30 seconds to try again.");
                TimeUnit.SECONDS.sleep(this.timeout);
                this.authenticate();
            }
            catch (InterruptedException e) {
                this.logger.error("Error with authentication", (Throwable)e);
            }
        }
    }

    @Override
    public void sessionAuthenticate() throws AuthenticationException {
        Response response;
        if (this.config == null) {
            return;
        }
        this.logger.info("Session auth");
        String sessionAuthTarget = this.config.getSessionAuthUrl();
        try {
            response = this.sessionAuthClient.target(sessionAuthTarget).path("/sessionauth/v1/authenticate").request(new String[]{"application/json"}).post(null);
        }
        catch (Exception e) {
            throw new AuthenticationException(e);
        }
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, null);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error, retry authentication in 30 seconds", (Throwable)e);
            }
            try {
                TimeUnit.SECONDS.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                this.logger.error("Error with session authentication", (Throwable)e);
            }
            if (this.authRetries++ > this.maxAuthRetries) {
                this.logger.error("Max retries reached. Giving up on auth.");
                return;
            }
            this.sessionAuthenticate();
        } else {
            Token sessionTokenResponseContent = (Token)response.readEntity(Token.class);
            this.sessionToken = sessionTokenResponseContent.getToken();
        }
    }

    @Override
    public void kmAuthenticate() throws AuthenticationException {
        Response response;
        this.logger.info("KM auth");
        if (this.config == null) {
            return;
        }
        String kmAuthTarget = this.config.getKeyAuthUrl();
        try {
            response = this.kmAuthClient.target(kmAuthTarget).path("/keyauth/v1/authenticate").request(new String[]{"application/json"}).post(null);
        }
        catch (Exception e) {
            throw new AuthenticationException(e);
        }
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, null);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error, retry authentication in 30 seconds", (Throwable)e);
            }
            try {
                TimeUnit.SECONDS.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                this.logger.error("Error with authentication", (Throwable)e);
            }
            if (this.authRetries++ > this.maxAuthRetries) {
                this.logger.error("Max retries reached. Giving up on auth.");
                return;
            }
            this.kmAuthenticate();
        } else {
            Token kmTokenResponseContent = (Token)response.readEntity(Token.class);
            this.kmToken = kmTokenResponseContent.getToken();
        }
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void setSessionToken(String sessionTokenInput) {
        this.sessionToken = sessionTokenInput;
    }

    @Override
    public String getKmToken() {
        return this.kmToken;
    }

    @Override
    public void setKmToken(String kmTokenInput) {
        this.kmToken = kmTokenInput;
    }

    @Override
    public void logout() {
        this.logger.info("Logging out");
        String target = this.config.getSessionAuthUrl();
        Invocation.Builder builder = this.sessionAuthClient.target(target).path("/sessionauth/v1/logout").request(new String[]{"application/json"}).header("sessionToken", (Object)this.getSessionToken());
        try (Response response = builder.post(null);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, null);
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error, retry logout in 30 seconds", (Throwable)e);
                }
            }
        }
    }
}

