/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.AuthEndpointConstants;
import authentication.ISymAuth;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import exceptions.AuthenticationException;
import internal.FileHelper;
import internal.jersey.JerseyHelper;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.vavr.CheckedFunction0;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import model.Token;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.HttpClientBuilderHelper;
import utils.JwtHelper;

public class SymBotRSAAuth
extends APIClient
implements ISymAuth {
    private static final Logger logger = LoggerFactory.getLogger(SymBotRSAAuth.class);
    private final SymConfig config;
    private final Client sessionAuthClient;
    private final Client kmAuthClient;
    private String sessionToken;
    private String kmToken;
    private String jwt;

    public SymBotRSAAuth(SymConfig config) {
        this(config, HttpClientBuilderHelper.getPodClientConfig(config), HttpClientBuilderHelper.getKMClientConfig(config));
    }

    public SymBotRSAAuth(SymConfig config, ClientConfig sessionAuthClientConfig, ClientConfig kmAuthClientConfig) {
        this.config = config;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config);
        this.sessionAuthClient = sessionAuthClientConfig != null ? clientBuilder.withConfig((Configuration)sessionAuthClientConfig).build() : clientBuilder.build();
        this.kmAuthClient = kmAuthClientConfig != null ? clientBuilder.withConfig((Configuration)kmAuthClientConfig).build() : clientBuilder.build();
    }

    @Override
    public void authenticate() throws AuthenticationException {
        this.refreshJwt();
        logger.debug("RSA authentication with {}", (Object)this.config.getRetry());
        RetryConfig config = RetryConfig.custom().maxAttempts(this.config.getRetry().getMaxAttempts()).intervalFunction(IntervalFunction.ofExponentialBackoff((long)this.config.getRetry().getInitialIntervalMillis(), (double)this.config.getRetry().getMultiplier())).build();
        RetryRegistry registry = RetryRegistry.of((RetryConfig)config);
        registry.retry("Session auth").executeCheckedSupplier((CheckedFunction0 & Serializable)() -> {
            this.sessionAuthenticate();
            return null;
        });
        registry.retry("KeyManager auth").executeCheckedSupplier((CheckedFunction0 & Serializable)() -> {
            this.kmAuthenticate();
            return null;
        });
    }

    @Override
    public void sessionAuthenticate() throws AuthenticationException {
        logger.debug("Starting session authentication...");
        this.sessionToken = this.doRsaAuth(this.sessionAuthClient, this.config.getPodUrl(), "/login/pubkey/authenticate", this.jwt);
        logger.debug("Session token successfully retrieved !");
    }

    @Override
    public void kmAuthenticate() throws AuthenticationException {
        logger.debug("Starting KM authentication...");
        this.kmToken = this.doRsaAuth(this.kmAuthClient, this.config.getKeyAuthUrl(), "/relay/pubkey/authenticate", this.jwt);
        logger.debug("KM token successfully retrieved !");
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Override
    public String getKmToken() {
        return this.kmToken;
    }

    @Override
    public void setKmToken(String kmToken) {
        this.kmToken = kmToken;
    }

    @Override
    public void logout() {
        logger.warn("Logout is not needed for RSA authentication.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doRsaAuth(Client client, String target, String path, String jwt) throws AuthenticationException {
        Token payload = new Token();
        payload.setToken(jwt);
        Invocation.Builder builder = client.target(target).path(path).request(new String[]{"application/json"});
        try (Response response = builder.post(Entity.entity((Object)payload, (String)"application/json"));){
            if (JerseyHelper.isNotSuccess(response)) {
                if (response.getStatus() == 401) {
                    logger.warn("JWT has expired, it will be refreshed before retry.");
                    this.refreshJwt();
                }
                String responsePayload = JerseyHelper.read(response, String.class);
                throw new AuthenticationException(responsePayload);
            }
            String string = JerseyHelper.read(response, Token.class).getToken();
            return string;
        }
        catch (ProcessingException ex) {
            logger.error("Unable to process RSA authentication request.", (Throwable)ex);
            throw new AuthenticationException((Exception)((Object)ex));
        }
    }

    private void refreshJwt() throws AuthenticationException {
        try {
            String privateKeyPath = FileHelper.path(this.config.getBotPrivateKeyPath(), this.config.getBotPrivateKeyName());
            PrivateKey privateKey = JwtHelper.parseRSAPrivateKey(FileHelper.readFile(privateKeyPath));
            this.jwt = JwtHelper.createSignedJwt(this.config.getBotUsername(), AuthEndpointConstants.JWT_EXPIRY_MS, privateKey);
            logger.debug("JWT successfully refresh for RSA authentication");
        }
        catch (IOException | GeneralSecurityException ex) {
            logger.error("Something went wrong while refreshing JWT, see cause below:", (Throwable)ex);
            throw new AuthenticationException(ex);
        }
    }
}

