/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.AbstractSymExtensionAppAuth;
import authentication.extensionapp.TokensRepository;
import configuration.SymConfig;
import java.util.HashMap;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import model.AppAuthResponse;
import model.UserInfo;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.HttpClientBuilderHelper;
import utils.JwtHelper;

public final class SymExtensionAppAuth
extends AbstractSymExtensionAppAuth {
    private static final Logger logger = LoggerFactory.getLogger(SymExtensionAppAuth.class);

    public SymExtensionAppAuth(SymConfig config) {
        super(config);
        ClientConfig clientConfig = HttpClientBuilderHelper.getPodClientConfig(config);
        this.initSessionAuthClient(config, clientConfig);
    }

    public SymExtensionAppAuth(SymConfig config, ClientConfig sessionAuthClientConfig) {
        super(config);
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientAppBuilder(config);
        this.initSessionAuthClient(config, sessionAuthClientConfig);
    }

    public SymExtensionAppAuth(SymConfig config, ClientConfig sessionAuthClientConfig, TokensRepository tokensRepository) {
        super(config, tokensRepository);
        this.initSessionAuthClient(config, sessionAuthClientConfig);
    }

    private void initSessionAuthClient(SymConfig config, ClientConfig clientConfig) {
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientAppBuilder(config);
        this.sessionAuthClient = clientConfig != null ? clientBuilder.withConfig((Configuration)clientConfig).build() : clientBuilder.build();
    }

    @Override
    public AppAuthResponse appAuthenticate() {
        String appToken = this.generateToken();
        return this.sessionAppAuthenticate(appToken, new String[0]);
    }

    @Override
    public AppAuthResponse sessionAppAuthenticate(String appToken, String ... podSessionAuthUrl) {
        String target = this.formattedPodSessionAuthUrl(podSessionAuthUrl);
        logger.info("Session extension app auth");
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("appToken", appToken);
        Invocation.Builder builder = this.sessionAuthClient.target(target).path("/sessionauth/v1/authenticate/extensionApp").request(new String[]{"application/json"});
        try (Response response = builder.post(Entity.entity(input, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                AppAuthResponse appAuthResponse = (AppAuthResponse)response.readEntity(AppAuthResponse.class);
                AppAuthResponse appAuthResponse2 = this.tokensRepository.save(appAuthResponse);
                return appAuthResponse2;
            }
            AppAuthResponse appAuthResponse = this.handleSessionAppAuthFailure(response, appToken, podSessionAuthUrl);
            return appAuthResponse;
        }
    }

    @Override
    public UserInfo verifyJWT(String jwt, String ... podSessionAuthUrl) {
        String podCertificate = this.getPodCertificate(podSessionAuthUrl);
        return JwtHelper.validateJwt(jwt, podCertificate);
    }

    @Override
    public Boolean validateTokens(String appToken, String symphonyToken) {
        return this.tokensRepository.get(appToken).filter(token -> token.getSymphonyToken().equals(symphonyToken)).isPresent();
    }

    private String getPodCertificate(String ... podSessionAuthUrl) {
        return this.getPodCertificateFromCertPath("/sessionauth/v1/app/pod/certificate", podSessionAuthUrl);
    }
}

