/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.AbstractSymExtensionAppAuth;
import authentication.AuthEndpointConstants;
import authentication.extensionapp.TokensRepository;
import configuration.SymConfig;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.HashMap;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import model.AppAuthResponse;
import model.UserInfo;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.CertificateUtils;
import utils.HttpClientBuilderHelper;
import utils.JwtHelper;

public final class SymExtensionAppRSAAuth
extends AbstractSymExtensionAppAuth {
    private static final Logger logger = LoggerFactory.getLogger(SymExtensionAppRSAAuth.class);
    private PrivateKey appPrivateKey;

    public SymExtensionAppRSAAuth(SymConfig config) {
        this(config, (PrivateKey)null);
    }

    public SymExtensionAppRSAAuth(SymConfig config, PrivateKey appPrivateKey) {
        super(config);
        this.appPrivateKey = appPrivateKey;
        ClientConfig clientConfig = HttpClientBuilderHelper.getPodClientConfig(config);
        this.initSessionAuthClient(config, clientConfig);
    }

    public SymExtensionAppRSAAuth(SymConfig config, ClientConfig sessionAuthClientConfig, TokensRepository tokensRepository) {
        super(config, tokensRepository);
        this.initSessionAuthClient(config, sessionAuthClientConfig);
    }

    private void initSessionAuthClient(SymConfig config, ClientConfig clientConfig) {
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config);
        this.sessionAuthClient = clientConfig != null ? clientBuilder.withConfig((Configuration)clientConfig).build() : clientBuilder.build();
    }

    @Override
    public AppAuthResponse appAuthenticate() {
        String appToken = this.generateToken();
        return this.sessionAppAuthenticate(appToken, new String[0]);
    }

    @Override
    public AppAuthResponse sessionAppAuthenticate(String appToken, String ... podSessionAuthUrl) {
        String target = this.formattedPodSessionAuthUrl(podSessionAuthUrl);
        logger.info("RSA extension app auth");
        PrivateKey appPrivateKey = this.getAppPrivateKey();
        String jwt = JwtHelper.createSignedJwt(this.config.getAppId(), AuthEndpointConstants.JWT_EXPIRY_MS, appPrivateKey);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("appToken", appToken);
        token.put("authToken", jwt);
        Invocation.Builder builder = this.sessionAuthClient.target(target).path("/login/v1/pubkey/app/authenticate/extensionApp").request(new String[]{"application/json"});
        try (Response response = builder.post(Entity.entity(token, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                AppAuthResponse appAuthResponse = (AppAuthResponse)response.readEntity(AppAuthResponse.class);
                AppAuthResponse appAuthResponse2 = this.tokensRepository.save(appAuthResponse);
                return appAuthResponse2;
            }
            AppAuthResponse appAuthResponse = this.handleSessionAppAuthFailure(response, appToken, podSessionAuthUrl);
            return appAuthResponse;
        }
    }

    @Override
    public UserInfo verifyJWT(String jwt, String ... podSessionAuthUrl) {
        String podCertificate = this.getPodCertificate(podSessionAuthUrl);
        return JwtHelper.validateJwt(jwt, podCertificate);
    }

    @Override
    public Boolean validateTokens(String appToken, String symphonyToken) {
        return this.tokensRepository.get(appToken).filter(token -> token.getSymphonyToken().equals(symphonyToken)).isPresent();
    }

    private PrivateKey getAppPrivateKey() {
        if (this.appPrivateKey == null) {
            try {
                String privateKeyFilePath = this.config.getAppPrivateKeyPath() + this.config.getAppPrivateKeyName();
                this.appPrivateKey = JwtHelper.parseRSAPrivateKey(new File(privateKeyFilePath));
            }
            catch (IOException | GeneralSecurityException e) {
                logger.error("Failed to obtain app RSA private key. An exception occurred parsing app RSA file", (Throwable)e);
            }
        }
        return this.appPrivateKey;
    }

    public PublicKey getPodPublicKey() throws CertificateException {
        String podCertificate = this.getPodCertificate(new String[0]);
        return CertificateUtils.parseX509Certificate(podCertificate).getPublicKey();
    }

    private String getPodCertificate(String ... podSessionAuthUrl) {
        return this.getPodCertificateFromCertPath("/pod/v1/podcert", podSessionAuthUrl);
    }
}

