/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.ISymOBOAuth;
import authentication.SymOBOUserAuth;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import exceptions.NoConfigException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import model.Token;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.HttpClientBuilderHelper;

public final class SymOBOAuth
extends APIClient
implements ISymOBOAuth {
    private final Logger logger = LoggerFactory.getLogger(SymOBOAuth.class);
    private String sessionToken;
    private SymConfig config;
    private Client sessionAuthClient;
    private int authRetries = 0;
    private int timeout;
    private int maxRetry;

    public SymOBOAuth(SymConfig configuration) {
        this.initConfig(configuration);
        this.timeout = 30;
        this.maxRetry = 5;
    }

    public SymOBOAuth(SymConfig configuration, ClientConfig sessionAuthClientConfig, int timeout, int maxRetry) {
        this.initConfig(configuration, sessionAuthClientConfig);
        this.timeout = timeout;
        this.maxRetry = maxRetry;
    }

    public SymOBOAuth(SymConfig configuration, ClientConfig sessionAuthClientConfig) {
        this.initConfig(configuration, sessionAuthClientConfig);
        this.timeout = 30;
        this.maxRetry = 5;
    }

    public SymOBOAuth(SymConfig configuration, int timeout, int maxRetry) {
        this.initConfig(configuration);
        this.timeout = timeout;
        this.maxRetry = maxRetry;
    }

    private void initConfig(SymConfig configuration) {
        this.logger.info("SymOBOAuth being constructed");
        this.config = configuration;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientAppBuilder(this.config);
        Client client = clientBuilder.build();
        if (StringUtils.isEmpty((CharSequence)this.config.getProxyURL())) {
            this.sessionAuthClient = client;
        } else {
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            clientConfig.property("jersey.config.client.proxy.uri", (Object)this.config.getProxyURL());
            if (!StringUtils.isEmpty((CharSequence)this.config.getProxyUsername()) && !StringUtils.isEmpty((CharSequence)this.config.getProxyPassword())) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)this.config.getProxyUsername());
                clientConfig.property("jersey.config.client.proxy.password", (Object)this.config.getProxyPassword());
            }
            this.sessionAuthClient = clientBuilder.withConfig((Configuration)clientConfig).build();
        }
    }

    private void initConfig(SymConfig configuration, ClientConfig sessionAuthClientConfig) {
        this.logger.info("SymOBOAuth being constructed with ClientConfig variable");
        this.config = configuration;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientAppBuilder(this.config);
        this.sessionAuthClient = sessionAuthClientConfig != null ? clientBuilder.withConfig((Configuration)sessionAuthClientConfig).build() : clientBuilder.build();
    }

    @Override
    public SymOBOUserAuth getUserAuth(String username) {
        SymOBOUserAuth userAuth = new SymOBOUserAuth(this.config, this.sessionAuthClient, username, (ISymOBOAuth)this, this.timeout);
        userAuth.authenticate();
        return userAuth;
    }

    @Override
    public SymOBOUserAuth getUserAuth(Long uid) {
        SymOBOUserAuth userAuth = new SymOBOUserAuth(this.config, this.sessionAuthClient, uid, (ISymOBOAuth)this, this.timeout);
        userAuth.authenticate();
        return userAuth;
    }

    @Override
    public void sessionAppAuthenticate() {
        if (this.config != null) {
            this.logger.info("Session app auth");
            Response response = this.sessionAuthClient.target(this.config.getSessionAuthUrl()).path("/sessionauth/v1/app/authenticate").request(new String[]{"application/json"}).post(null);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, null);
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error, retry authentication in {} seconds", (Object)this.timeout);
                }
                try {
                    TimeUnit.SECONDS.sleep(this.timeout);
                }
                catch (InterruptedException e) {
                    this.logger.error("Error with session app authentication", (Throwable)e);
                }
                if (this.authRetries++ > this.maxRetry) {
                    this.logger.error("Max retries reached. Giving up on auth.");
                    return;
                }
                this.sessionAppAuthenticate();
            } else {
                Token sessionTokenResponseContent = (Token)response.readEntity(Token.class);
                this.sessionToken = sessionTokenResponseContent.getToken();
            }
        } else {
            throw new NoConfigException("Must provide a SymConfig object to authenticate");
        }
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }
}

