/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.ISymAuth;
import authentication.ISymOBOAuth;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import model.SessionToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SymOBOUserAuth
extends APIClient
implements ISymAuth {
    private final Logger logger = LoggerFactory.getLogger(SymOBOUserAuth.class);
    private String sessionToken;
    private SymConfig config;
    private Client sessionAuthClient;
    private Long uid;
    private String username;
    private ISymOBOAuth appAuth;
    private int authRetries = 0;
    private int timeout = 30;
    private int maxRetry = 5;

    public SymOBOUserAuth(SymConfig config, Client sessionAuthClient, Long uid, ISymOBOAuth appAuth) {
        this.config = config;
        this.sessionAuthClient = sessionAuthClient;
        this.uid = uid;
        this.appAuth = appAuth;
    }

    public SymOBOUserAuth(SymConfig config, Client sessionAuthClient, Long uid, ISymOBOAuth appAuth, int timeout) {
        this.config = config;
        this.sessionAuthClient = sessionAuthClient;
        this.uid = uid;
        this.appAuth = appAuth;
        this.timeout = timeout;
    }

    public SymOBOUserAuth(SymConfig config, Client sessionAuthClient, String username, ISymOBOAuth appAuth) {
        this.config = config;
        this.sessionAuthClient = sessionAuthClient;
        this.username = username;
        this.appAuth = appAuth;
    }

    public SymOBOUserAuth(SymConfig config, Client sessionAuthClient, String username, ISymOBOAuth appAuth, int timeout) {
        this.config = config;
        this.sessionAuthClient = sessionAuthClient;
        this.username = username;
        this.appAuth = appAuth;
        this.timeout = timeout;
    }

    protected SymOBOUserAuth(SymConfig config, Client sessionAuthClient, String username, ISymOBOAuth appAuth, int timeout, int maxRetry) {
        this.config = config;
        this.sessionAuthClient = sessionAuthClient;
        this.username = username;
        this.appAuth = appAuth;
        this.maxRetry = maxRetry;
        this.timeout = timeout;
    }

    @Override
    public void authenticate() {
        this.sessionAuthenticate();
    }

    @Override
    public void sessionAuthenticate() {
        block21: {
            String target = this.config.getSessionAuthUrl();
            String path = this.uid != null ? "/sessionauth/v1/app/user/{uid}/authenticate".replace("{uid}", Long.toString(this.uid)) : "/sessionauth/v1/app/username/{username}/authenticate".replace("{username}", this.username);
            Invocation.Builder builder = this.sessionAuthClient.target(target).path(path).request(new String[]{"application/json"}).header("sessionToken", (Object)this.appAuth.getSessionToken());
            try (Response response = builder.post(null);){
                if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                    try {
                        this.handleError(response, null);
                    }
                    catch (Exception e) {
                        this.logger.error("Unexpected error, retry authentication in 30 seconds");
                    }
                    try {
                        TimeUnit.SECONDS.sleep(this.timeout);
                    }
                    catch (InterruptedException e) {
                        this.logger.error("Error with authentication", (Throwable)e);
                    }
                    if (this.authRetries++ > this.maxRetry) {
                        this.logger.error("Max retries reached. Giving up on auth.");
                        return;
                    }
                    this.appAuth.sessionAppAuthenticate();
                    this.sessionAuthenticate();
                    break block21;
                }
                SessionToken session = (SessionToken)response.readEntity(SessionToken.class);
                this.sessionToken = session.getSessionToken();
            }
        }
    }

    @Override
    public void kmAuthenticate() {
        this.logger.warn("method kmAuthenticate is invalid");
        throw new RuntimeException("this method is not supported");
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Override
    public String getKmToken() {
        this.logger.warn("method kmAuthenticate is invalid");
        throw new RuntimeException("this method kmAuthenticate is not supported");
    }

    @Override
    public void setKmToken(String kmToken) {
        this.logger.warn("method setKmToken is invalid");
        throw new RuntimeException("this method setKmToken is not supported");
    }

    @Override
    public void logout() {
    }
}

