/*
 * Decompiled with CFR 0.152.
 */
package clients;

import authentication.ISymAuth;
import authentication.SymBotAuth;
import authentication.SymBotRSAAuth;
import clients.ISymClient;
import clients.symphony.api.APIClient;
import clients.symphony.api.AdminClient;
import clients.symphony.api.ConnectionsClient;
import clients.symphony.api.DatafeedClient;
import clients.symphony.api.FirehoseClient;
import clients.symphony.api.HealthcheckClient;
import clients.symphony.api.InformationBarriersClient;
import clients.symphony.api.MessagesClient;
import clients.symphony.api.PresenceClient;
import clients.symphony.api.SignalsClient;
import clients.symphony.api.StreamsClient;
import clients.symphony.api.UsersClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import configuration.LoadBalancingMethod;
import configuration.SymConfig;
import configuration.SymConfigLoader;
import configuration.SymLoadBalancedConfig;
import exceptions.AuthenticationException;
import java.io.File;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import model.UserInfo;
import org.apache.commons.codec.binary.Base64;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import services.DatafeedEventsService;
import services.FirehoseService;
import utils.HttpClientBuilderHelper;
import utils.SymMessageParser;

public final class SymBotClient
implements ISymClient {
    private static final Logger logger = LoggerFactory.getLogger(SymBotClient.class);
    private static final String DATAFEED_ID_FILE = "datafeed.id";
    private static SymBotClient botClient;
    private SymConfig config;
    private ISymAuth symBotAuth;
    private DatafeedClient datafeedClient;
    private MessagesClient messagesClient;
    private PresenceClient presenceClient;
    private StreamsClient streamsClient;
    private UsersClient usersClient;
    private ConnectionsClient connectionsClient;
    private DatafeedEventsService datafeedEventsService;
    private SignalsClient signalsClient;
    private UserInfo botUserInfo;
    private Client podClient;
    private Client agentClient;
    private AdminClient adminClient;
    private FirehoseClient firehoseClient;
    private FirehoseService firehoseService;
    private HealthcheckClient healthcheckClient;
    private InformationBarriersClient informationBarriersClient;

    public static SymBotClient initBotRsa(String configPath) throws Exception {
        return SymBotClient.initBotRsa(configPath, SymConfig.class);
    }

    public static <T extends SymConfig> SymBotClient initBotRsa(String configPath, Class<T> clazz) throws Exception {
        return SymBotClient.initBot(configPath, clazz, true);
    }

    public static SymBotClient initBot(String configPath) throws Exception {
        return SymBotClient.initBot(configPath, SymConfig.class);
    }

    public static <T extends SymConfig> SymBotClient initBot(String configPath, Class<T> clazz) throws Exception {
        return SymBotClient.initBot(configPath, clazz, false);
    }

    private static <T extends SymConfig> SymBotClient initBot(String configPath, Class<T> clazz, boolean isRsa) throws Exception {
        if (botClient != null) {
            return botClient;
        }
        T config = SymConfigLoader.loadConfig(configPath, clazz);
        APIClient botAuth = isRsa ? new SymBotRSAAuth((SymConfig)config) : new SymBotAuth((SymConfig)config);
        try {
            botAuth.authenticate();
        }
        catch (AuthenticationException e) {
            if (e.hasRootException()) {
                throw e.getRootException();
            }
            throw e;
        }
        return new SymBotClient((SymConfig)config, (ISymAuth)((Object)botAuth));
    }

    public static SymBotClient initBot(SymConfig config, ISymAuth botAuth) {
        if (botClient == null) {
            botClient = new SymBotClient(config, botAuth);
            return botClient;
        }
        return botClient;
    }

    public static SymBotClient initBot(SymConfig config, ISymAuth botAuth, SymLoadBalancedConfig lbConfig) {
        if (botClient == null) {
            lbConfig.cloneAttributes(config);
            botClient = new SymBotClient(lbConfig, botAuth);
            return botClient;
        }
        return botClient;
    }

    public static SymBotClient initBot(SymConfig config, ISymAuth botAuth, ClientConfig podClientConfig, ClientConfig agentClientConfig) {
        if (botClient == null) {
            botClient = new SymBotClient(config, botAuth, podClientConfig, agentClientConfig);
            return botClient;
        }
        return botClient;
    }

    public static SymBotClient initBot(SymConfig config, ISymAuth botAuth, ClientConfig podClientConfig, ClientConfig agentClientConfig, SymLoadBalancedConfig lbConfig) {
        if (botClient == null) {
            lbConfig.cloneAttributes(config);
            botClient = new SymBotClient(config, botAuth, podClientConfig, agentClientConfig);
            return botClient;
        }
        return botClient;
    }

    public static SymBotClient initBotLoadBalancedRsa(String configPath, String lbConfigPath) throws Exception {
        return SymBotClient.initBotLoadBalancedRsa(configPath, lbConfigPath, SymConfig.class);
    }

    public static <T extends SymConfig> SymBotClient initBotLoadBalancedRsa(String configPath, String lbConfigPath, Class<T> clazz) throws Exception {
        return SymBotClient.initBotLoadBalanced(configPath, lbConfigPath, clazz, true);
    }

    public static SymBotClient initBotLoadBalanced(String configPath, String lbConfigPath) throws Exception {
        return SymBotClient.initBotLoadBalanced(configPath, lbConfigPath, SymConfig.class);
    }

    public static <T extends SymConfig> SymBotClient initBotLoadBalanced(String configPath, String lbConfigPath, Class<T> clazz) throws Exception {
        return SymBotClient.initBotLoadBalanced(configPath, lbConfigPath, clazz, false);
    }

    private static <T extends SymConfig> SymBotClient initBotLoadBalanced(String configPath, String lbConfigPath, Class<T> clazz, boolean isRsa) throws Exception {
        if (botClient == null) {
            T config = SymConfigLoader.loadConfig(configPath, clazz);
            SymLoadBalancedConfig lbConfig = SymConfigLoader.loadConfig(lbConfigPath, SymLoadBalancedConfig.class);
            APIClient botAuth = isRsa ? new SymBotRSAAuth((SymConfig)config) : new SymBotAuth((SymConfig)config);
            try {
                botAuth.authenticate();
            }
            catch (AuthenticationException e) {
                throw e.getRootException();
            }
            lbConfig.cloneAttributes((SymConfig)config);
            botClient = new SymBotClient(lbConfig, (ISymAuth)((Object)botAuth));
        }
        return botClient;
    }

    private SymBotClient(SymConfig config, ISymAuth symBotAuth) {
        this.config = config;
        this.symBotAuth = symBotAuth;
        ClientConfig podConfig = HttpClientBuilderHelper.getPodClientConfig(config);
        ClientConfig agentConfig = HttpClientBuilderHelper.getAgentClientConfig(config);
        this.podClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)podConfig).build();
        this.agentClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)agentConfig).build();
        this.botUserInfo = this.parseUserFromSessionToken(symBotAuth.getSessionToken());
        if (this.botUserInfo == null) {
            logger.debug("Calling getSessionUser to get bot info.");
            this.getBotUserInfo();
        }
        SymMessageParser.createInstance(this);
        this.reportIfLoadBalanced(config);
    }

    private SymBotClient(SymConfig config, ISymAuth symBotAuth, ClientConfig podClientConfig, ClientConfig agentClientConfig) {
        this.config = config;
        this.symBotAuth = symBotAuth;
        this.podClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)podClientConfig).build();
        this.agentClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)agentClientConfig).build();
        this.botUserInfo = this.parseUserFromSessionToken(symBotAuth.getSessionToken());
        if (this.botUserInfo == null) {
            logger.debug("Calling getSessionUser to get bot info.");
            this.getBotUserInfo();
        }
        SymMessageParser.createInstance(this);
        this.reportIfLoadBalanced(config);
    }

    private UserInfo parseUserFromSessionToken(String sessionToken) {
        try {
            String userToken = sessionToken.split("\\.")[1];
            String decodedUserToken = new String(Base64.decodeBase64((byte[])userToken.getBytes()));
            JsonNode jsonNode = new ObjectMapper().readTree(decodedUserToken);
            UserInfo user = new UserInfo();
            user.setUsername(jsonNode.path("sub").asText());
            user.setId(jsonNode.path("userId").asLong());
            logger.info("Authenticated as {} ({})", (Object)user.getUsername(), (Object)user.getId());
            return user;
        }
        catch (JsonProcessingException | ArrayIndexOutOfBoundsException e) {
            logger.error("Unable to parse user info");
            return null;
        }
    }

    private void reportIfLoadBalanced(SymConfig config) {
        if (config instanceof SymLoadBalancedConfig) {
            SymLoadBalancedConfig lbConfig = (SymLoadBalancedConfig)config;
            LoadBalancingMethod method = lbConfig.getLoadBalancing().getMethod();
            logger.info("Using load-balanced configuration with method: {}", (Object)method);
            if (lbConfig.getLoadBalancing().getMethod() != LoadBalancingMethod.external) {
                logger.info("Agent server list: {}", (Object)String.join((CharSequence)", ", lbConfig.getAgentServers()));
            }
        }
    }

    public UserInfo getBotUserInfo() {
        if (this.botUserInfo == null || this.botUserInfo.getEmailAddress() == null) {
            this.botUserInfo = this.getUsersClient().getSessionUser();
        }
        return this.botUserInfo;
    }

    public String getBotUsername() {
        if (this.botUserInfo == null || this.botUserInfo.getUsername() == null) {
            this.getBotUserInfo();
        }
        return this.botUserInfo.getUsername();
    }

    public long getBotUserId() {
        if (this.botUserInfo == null || this.botUserInfo.getId() == null) {
            this.getBotUserInfo();
        }
        return this.botUserInfo.getId();
    }

    public DatafeedClient getDatafeedClient() {
        if (this.datafeedClient == null) {
            this.datafeedClient = new DatafeedClient(this);
        }
        return this.datafeedClient;
    }

    public FirehoseClient getFirehoseClient() {
        if (this.firehoseClient == null) {
            this.firehoseClient = new FirehoseClient(this);
        }
        return this.firehoseClient;
    }

    public FirehoseService getFirehoseService() {
        if (this.firehoseService == null) {
            this.firehoseService = new FirehoseService(this);
        }
        return this.firehoseService;
    }

    @Override
    public SymConfig getConfig() {
        return this.config;
    }

    public <T extends SymConfig> T getConfig(Class<T> clazz) {
        return (T)((SymConfig)clazz.cast(this.config));
    }

    public File getDatafeedIdFile() {
        String pathToDatafeedIdFile = this.config.getDatafeedIdFilePath() + DATAFEED_ID_FILE;
        File file = new File(pathToDatafeedIdFile);
        if (file.isDirectory()) {
            file = new File(pathToDatafeedIdFile + File.separator + DATAFEED_ID_FILE);
        }
        return file;
    }

    @Override
    public ISymAuth getSymAuth() {
        return this.symBotAuth;
    }

    @Override
    public MessagesClient getMessagesClient() {
        if (this.messagesClient == null) {
            SymMessageParser.createInstance(this);
            this.messagesClient = new MessagesClient(this);
        }
        return this.messagesClient;
    }

    @Override
    public PresenceClient getPresenceClient() {
        if (this.presenceClient == null) {
            this.presenceClient = new PresenceClient(this);
        }
        return this.presenceClient;
    }

    @Override
    public StreamsClient getStreamsClient() {
        if (this.streamsClient == null) {
            this.streamsClient = new StreamsClient(this);
        }
        return this.streamsClient;
    }

    @Override
    public UsersClient getUsersClient() {
        if (this.usersClient == null) {
            this.usersClient = new UsersClient(this);
        }
        return this.usersClient;
    }

    @Override
    public ConnectionsClient getConnectionsClient() {
        if (this.connectionsClient == null) {
            this.connectionsClient = new ConnectionsClient(this);
        }
        return this.connectionsClient;
    }

    public DatafeedEventsService getDatafeedEventsService() {
        if (this.datafeedEventsService == null) {
            this.datafeedEventsService = new DatafeedEventsService(this);
        }
        return this.datafeedEventsService;
    }

    @Override
    public SignalsClient getSignalsClient() {
        if (this.signalsClient == null) {
            this.signalsClient = new SignalsClient(this);
        }
        return this.signalsClient;
    }

    public AdminClient getAdminClient() {
        if (this.adminClient == null) {
            this.adminClient = new AdminClient(this);
        }
        return this.adminClient;
    }

    public HealthcheckClient getHealthcheckClient() {
        if (this.healthcheckClient == null) {
            this.healthcheckClient = new HealthcheckClient(this);
        }
        return this.healthcheckClient;
    }

    public InformationBarriersClient getInformationBarriersClient() {
        if (this.informationBarriersClient == null) {
            this.informationBarriersClient = new InformationBarriersClient(this);
        }
        return this.informationBarriersClient;
    }

    public static void clearBotClient() {
        botClient = null;
    }

    public static SymBotClient getBotClient() {
        return botClient;
    }

    @Override
    public Client getPodClient() {
        return this.podClient;
    }

    @Override
    public Client getAgentClient() {
        return this.agentClient;
    }

    @Override
    public void setPodClient(Client podClient) {
        this.podClient = podClient;
    }

    @Override
    public void setAgentClient(Client agentClient) {
        this.agentClient = agentClient;
    }
}

