/*
 * Decompiled with CFR 0.152.
 */
package clients;

import authentication.ISymAuth;
import clients.ISymClient;
import clients.symphony.api.ConnectionsClient;
import clients.symphony.api.MessagesClient;
import clients.symphony.api.PresenceClient;
import clients.symphony.api.SignalsClient;
import clients.symphony.api.StreamsClient;
import clients.symphony.api.UsersClient;
import configuration.SymConfig;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import utils.HttpClientBuilderHelper;

public final class SymOBOClient
implements ISymClient {
    private SymConfig config;
    private ISymAuth symAuth;
    private MessagesClient messagesClient;
    private PresenceClient presenceClient;
    private StreamsClient streamsClient;
    private UsersClient usersClient;
    private ConnectionsClient connectionsClient;
    private SignalsClient signalsClient;
    private Client podClient;
    private Client agentClient;

    @Deprecated
    public static SymOBOClient initOBOClient(SymConfig config, ISymAuth auth) {
        return new SymOBOClient(config, auth);
    }

    public SymOBOClient(SymConfig config, ISymAuth symAuth) {
        this.config = config;
        this.symAuth = symAuth;
        ClientConfig agentConfig = HttpClientBuilderHelper.getAgentClientConfig(config);
        ClientConfig podConfig = HttpClientBuilderHelper.getPodClientConfig(config);
        this.agentClient = agentConfig == null ? HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).build() : HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)agentConfig).build();
        this.podClient = podConfig == null ? HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).build() : HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)podConfig).build();
    }

    @Override
    public SymConfig getConfig() {
        return this.config;
    }

    @Override
    public ISymAuth getSymAuth() {
        return this.symAuth;
    }

    @Override
    public MessagesClient getMessagesClient() {
        if (this.messagesClient == null) {
            this.messagesClient = new MessagesClient(this);
        }
        return this.messagesClient;
    }

    @Override
    public PresenceClient getPresenceClient() {
        if (this.presenceClient == null) {
            this.presenceClient = new PresenceClient(this);
        }
        return this.presenceClient;
    }

    @Override
    public StreamsClient getStreamsClient() {
        if (this.streamsClient == null) {
            this.streamsClient = new StreamsClient(this);
        }
        return this.streamsClient;
    }

    @Override
    public UsersClient getUsersClient() {
        if (this.usersClient == null) {
            this.usersClient = new UsersClient(this);
        }
        return this.usersClient;
    }

    @Override
    public ConnectionsClient getConnectionsClient() {
        if (this.connectionsClient == null) {
            this.connectionsClient = new ConnectionsClient(this);
        }
        return this.connectionsClient;
    }

    @Override
    public SignalsClient getSignalsClient() {
        if (this.signalsClient == null) {
            this.signalsClient = new SignalsClient(this);
        }
        return this.signalsClient;
    }

    @Override
    public Client getPodClient() {
        return this.podClient;
    }

    @Override
    public Client getAgentClient() {
        return this.agentClient;
    }

    @Override
    public void setPodClient(Client podClient) {
        this.podClient = podClient;
    }

    @Override
    public void setAgentClient(Client agentClient) {
        this.agentClient = agentClient;
    }
}

