/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import exceptions.APIClientErrorException;
import exceptions.AuthenticationException;
import exceptions.ForbiddenException;
import exceptions.ServerErrorException;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import javax.ws.rs.core.Response;
import model.ClientError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APIClient {
    private final Logger logger = LoggerFactory.getLogger(APIClient.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    private ClientError readClientError(Response response) {
        String errorString = (String)response.readEntity(String.class);
        try {
            return (ClientError)mapper.readValue(errorString, ClientError.class);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error response is not in json format: {}", (Object)errorString);
            ClientError error = new ClientError();
            error.setMessage(errorString);
            return error;
        }
    }

    public void handleError(Response response, ISymClient botClient) throws SymClientException {
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SERVER_ERROR) {
            this.logger.error("REST error: error code {} reason {}", (Object)response.getStatusInfo().getStatusCode(), (Object)response.getStatusInfo().getReasonPhrase());
            throw new ServerErrorException(response.getStatusInfo().getReasonPhrase());
        }
        ClientError error = this.readClientError(response);
        if (response.getStatus() == Response.Status.BAD_REQUEST.getStatusCode()) {
            this.logger.error("Client error occurred: {}", (Object)error.getMessage());
            throw new APIClientErrorException(error.getMessage());
        }
        if (response.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            this.logger.error("User unauthorized, refreshing tokens");
            if (botClient != null) {
                try {
                    botClient.getSymAuth().authenticate();
                }
                catch (AuthenticationException e) {
                    throw new SymClientException("Authentication Exception");
                }
            }
            throw new UnauthorizedException(error.getMessage());
        }
        if (response.getStatus() == Response.Status.FORBIDDEN.getStatusCode()) {
            this.logger.error("Forbidden: Caller lacks necessary entitlement.");
            throw new ForbiddenException(error.getMessage());
        }
    }
}

