/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import model.AdminNewUser;
import model.AdminStreamFilter;
import model.AdminUserAttributes;
import model.AdminUserInfo;
import model.AdminUserInfoList;
import model.ApplicationEntitlement;
import model.ApplicationEntitlementList;
import model.Avatar;
import model.AvatarList;
import model.FeatureEntitlement;
import model.FeatureEntitlementList;
import model.InboundImportMessageList;
import model.OutboundImportMessageList;
import model.Status;
import model.StringId;
import model.SuppressionResult;
import model.UserStatus;
import model.events.AdminStreamInfoList;
import org.apache.commons.codec.binary.Base64;

public final class AdminClient
extends APIClient {
    private ISymClient botClient;

    public AdminClient(ISymClient client) {
        this.botClient = client;
    }

    public InboundImportMessageList importMessages(OutboundImportMessageList messageList) throws SymClientException {
        Invocation.Builder builder = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v4/message/import").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        try (Response response = builder.post(Entity.entity((Object)messageList, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundImportMessageList inboundImportMessageList = this.importMessages(messageList);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return inboundImportMessageList;
                }
                InboundImportMessageList inboundImportMessageList = null;
                return inboundImportMessageList;
            }
            InboundImportMessageList inboundImportMessageList = (InboundImportMessageList)response.readEntity(InboundImportMessageList.class);
            return inboundImportMessageList;
        }
    }

    public SuppressionResult suppressMessage(String id) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/messagesuppression/{id}/suppress".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(null);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    SuppressionResult suppressionResult = this.suppressMessage(id);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return suppressionResult;
                }
                SuppressionResult suppressionResult = null;
                return suppressionResult;
            }
            SuppressionResult suppressionResult = (SuppressionResult)response.readEntity(SuppressionResult.class);
            return suppressionResult;
        }
    }

    public AdminStreamInfoList listEnterpriseStreams(AdminStreamFilter filter, int skip, int limit) throws SymClientException {
        WebTarget webTarget = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v2/admin/streams/list");
        if (skip > 0) {
            webTarget = webTarget.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            webTarget = webTarget.queryParam("limit", new Object[]{limit});
        }
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)filter, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    AdminStreamInfoList adminStreamInfoList = this.listEnterpriseStreams(filter, skip, limit);
                    if (response != null) {
                        if (var7_7 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var7_7.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return adminStreamInfoList;
                }
                AdminStreamInfoList adminStreamInfoList = null;
                return adminStreamInfoList;
            }
            AdminStreamInfoList adminStreamInfoList = (AdminStreamInfoList)response.readEntity(AdminStreamInfoList.class);
            return adminStreamInfoList;
        }
    }

    public String createIM(List<Long> userIdList) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/im/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity(userIdList, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    String string = this.createIM(userIdList);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return string;
                }
                String string = null;
                return string;
            }
            String string = ((StringId)response.readEntity(StringId.class)).getId();
            return string;
        }
    }

    public AdminUserInfo getUser(Long uid) throws NoContentException, SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v2/admin/user/{uid}".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    AdminUserInfo adminUserInfo = this.getUser(uid);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return adminUserInfo;
                }
                AdminUserInfo adminUserInfo = null;
                return adminUserInfo;
            }
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                throw new NoContentException("No user found.");
            }
            AdminUserInfo adminUserInfo = (AdminUserInfo)response.readEntity(AdminUserInfo.class);
            return adminUserInfo;
        }
    }

    public List<AdminUserInfo> listUsers(int skip, int limit) throws SymClientException {
        block25: {
            WebTarget webTarget = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v2/admin/user/list");
            if (skip > 0) {
                webTarget = webTarget.queryParam("skip", new Object[]{skip});
            }
            if (limit > 0) {
                webTarget = webTarget.queryParam("limit", new Object[]{limit});
            }
            Invocation.Builder builder = webTarget.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
            try (Response response = builder.get();){
                if (response.getStatus() == 200) {
                    List list = (List)response.readEntity(AdminUserInfoList.class);
                    return list;
                }
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) break block25;
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<AdminUserInfo> list = this.listUsers(skip, limit);
                    if (response != null) {
                        if (var6_6 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var6_6.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
            }
        }
        return null;
    }

    public AdminUserInfo createUser(AdminNewUser newUser) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v2/admin/user/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)newUser, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    AdminUserInfo adminUserInfo = this.createUser(newUser);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return adminUserInfo;
                }
                AdminUserInfo adminUserInfo = null;
                return adminUserInfo;
            }
            AdminUserInfo adminUserInfo = (AdminUserInfo)response.readEntity(AdminUserInfo.class);
            return adminUserInfo;
        }
    }

    public AdminUserInfo updateUser(Long userId, AdminUserAttributes userAttributes) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v2/admin/user/{uid}/update".replace("{uid}", Long.toString(userId))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)userAttributes, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    AdminUserInfo adminUserInfo = this.updateUser(userId, userAttributes);
                    if (response != null) {
                        if (var5_5 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return adminUserInfo;
                }
                AdminUserInfo adminUserInfo = null;
                return adminUserInfo;
            }
            AdminUserInfo adminUserInfo = (AdminUserInfo)response.readEntity(AdminUserInfo.class);
            return adminUserInfo;
        }
    }

    public List<Avatar> getAvatar(Long uid) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/user/{uid}/avatar".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<Avatar> list = this.getAvatar(uid);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<Avatar> list = null;
                return list;
            }
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                throw new SymClientException("No user found for userid:= " + uid);
            }
            List list = (List)response.readEntity(AvatarList.class);
            return list;
        }
    }

    public void updateAvatar(Long userId, String filePath) throws IOException, SymClientException {
        HashMap<String, String> input = new HashMap<String, String>();
        File f = new File(filePath);
        try (FileInputStream fis = new FileInputStream(f);){
            byte[] byteArray = new byte[(int)f.length()];
            fis.read(byteArray);
            String imageString = Base64.encodeBase64String((byte[])byteArray);
            input.put("image", imageString);
        }
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/user/{uid}/avatar/update".replace("{uid}", Long.toString(userId))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity(input, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.updateAvatar(userId, filePath);
                }
            }
        }
    }

    public String getUserStatus(Long uid) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/user/{uid}/status".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    String string = this.getUserStatus(uid);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return string;
                }
                String ex = null;
                return ex;
            }
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                throw new SymClientException("No user found for userid:= " + uid);
            }
            Status status = (Status)response.readEntity(Status.class);
            String string = status.getStatus();
            return string;
        }
    }

    public void updateUserStatus(Long uid, UserStatus status) throws SymClientException {
        this.updateUserStatus(uid, status.toString());
    }

    public void updateUserStatus(Long uid, String status) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/user/{uid}/status/update".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        Entity entity = Entity.entity((Object)new Status(status), (String)"application/json");
        try (Response response = builder.post(entity);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.updateUserStatus(uid, status);
                }
            } else if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                throw new SymClientException("No user found for userId: " + uid);
            }
        }
    }

    public List<String> listPodFeatures() throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/system/features/list").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<String> list = this.listPodFeatures();
                    if (response != null) {
                        if (var3_3 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var3_3.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<String> list = null;
                return list;
            }
            List list = (List)response.readEntity((GenericType)new GenericType<List<String>>(){});
            return list;
        }
    }

    public List<FeatureEntitlement> getUserFeatures(Long uid) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/user/{uid}/features".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<FeatureEntitlement> list = this.getUserFeatures(uid);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<FeatureEntitlement> list = null;
                return list;
            }
            List list = (List)response.readEntity(FeatureEntitlementList.class);
            return list;
        }
    }

    public void updateUserFeatures(Long uid, List<FeatureEntitlement> entitlements) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/user/{uid}/features/update".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity(entitlements, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.updateUserFeatures(uid, entitlements);
                }
            }
        }
    }

    public List<ApplicationEntitlement> getUserApplicationEntitlements(Long uid) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/user/{uid}/app/entitlement/list".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<ApplicationEntitlement> list = this.getUserApplicationEntitlements(uid);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<ApplicationEntitlement> list = null;
                return list;
            }
            List list = (List)response.readEntity(ApplicationEntitlementList.class);
            return list;
        }
    }

    public List<ApplicationEntitlement> updateUserApplicationEntitlements(Long uid, List<ApplicationEntitlement> entitlementsUpdate) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/user/{uid}/app/entitlement/list".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity(entitlementsUpdate, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<ApplicationEntitlement> list = this.updateUserApplicationEntitlements(uid, entitlementsUpdate);
                    if (response != null) {
                        if (var5_5 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<ApplicationEntitlement> list = null;
                return list;
            }
            List list = (List)response.readEntity(ApplicationEntitlementList.class);
            return list;
        }
    }
}

