/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import model.InboundConnectionRequest;
import model.InboundConnectionRequestList;

public final class ConnectionsClient
extends APIClient {
    private ISymClient botClient;

    public ConnectionsClient(ISymClient client) {
        this.botClient = client;
    }

    public List<InboundConnectionRequest> getPendingConnections() throws SymClientException {
        return this.getConnections(null, null);
    }

    public List<InboundConnectionRequest> getInboundPendingConnections() throws SymClientException {
        return this.getConnections("PENDING_INCOMING", null);
    }

    public List<InboundConnectionRequest> getAllConnections() throws SymClientException {
        return this.getConnections("ALL", null);
    }

    public List<InboundConnectionRequest> getAcceptedConnections() throws SymClientException {
        return this.getConnections("ACCEPTED", null);
    }

    public List<InboundConnectionRequest> getRejectedConnections() throws SymClientException {
        return this.getConnections("REJECTED", null);
    }

    public List<InboundConnectionRequest> getConnections(String status, List<Long> userIds) throws SymClientException {
        String userIdString = null;
        if (userIds != null && !userIds.isEmpty()) {
            userIdString = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        WebTarget webTarget = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/connection/list");
        if (status != null) {
            webTarget = webTarget.queryParam("status", new Object[]{status});
        }
        if (userIdString != null) {
            webTarget = webTarget.queryParam("userIds", new Object[]{userIdString});
        }
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<InboundConnectionRequest> list = this.getConnections(status, userIds);
                    if (response != null) {
                        if (var7_7 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var7_7.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<InboundConnectionRequest> list = null;
                return list;
            }
            List list = (List)response.readEntity(InboundConnectionRequestList.class);
            return list;
        }
    }

    public InboundConnectionRequest acceptConnectionRequest(Long userId) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/connection/accept").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        Entity entity = Entity.entity((Object)new UserId(userId), (String)"application/json");
        try (Response response = builder.post(entity);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundConnectionRequest inboundConnectionRequest = this.acceptConnectionRequest(userId);
                    if (response != null) {
                        if (var5_5 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return inboundConnectionRequest;
                }
                InboundConnectionRequest inboundConnectionRequest = null;
                return inboundConnectionRequest;
            }
            InboundConnectionRequest inboundConnectionRequest = (InboundConnectionRequest)response.readEntity(InboundConnectionRequest.class);
            return inboundConnectionRequest;
        }
    }

    public InboundConnectionRequest rejectConnectionRequest(Long userId) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/connection/reject").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        Entity entity = Entity.entity((Object)new UserId(userId), (String)"application/json");
        try (Response response = builder.post(entity);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundConnectionRequest inboundConnectionRequest = this.rejectConnectionRequest(userId);
                    if (response != null) {
                        if (var5_5 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return inboundConnectionRequest;
                }
                InboundConnectionRequest inboundConnectionRequest = null;
                return inboundConnectionRequest;
            }
            InboundConnectionRequest inboundConnectionRequest = (InboundConnectionRequest)response.readEntity(InboundConnectionRequest.class);
            return inboundConnectionRequest;
        }
    }

    public InboundConnectionRequest sendConnectionRequest(Long userId) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/connection/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        Entity entity = Entity.entity((Object)new UserId(userId), (String)"application/json");
        try (Response response = builder.post(entity);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundConnectionRequest inboundConnectionRequest = this.sendConnectionRequest(userId);
                    if (response != null) {
                        if (var5_5 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return inboundConnectionRequest;
                }
                InboundConnectionRequest inboundConnectionRequest = null;
                return inboundConnectionRequest;
            }
            InboundConnectionRequest inboundConnectionRequest = (InboundConnectionRequest)response.readEntity(InboundConnectionRequest.class);
            return inboundConnectionRequest;
        }
    }

    public InboundConnectionRequest getConnectionRequestStatus(Long userId) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/connection/user/{userId}/info".replace("{userId}", Long.toString(userId))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundConnectionRequest inboundConnectionRequest = this.getConnectionRequestStatus(userId);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return inboundConnectionRequest;
                }
                InboundConnectionRequest inboundConnectionRequest = null;
                return inboundConnectionRequest;
            }
            InboundConnectionRequest inboundConnectionRequest = (InboundConnectionRequest)response.readEntity(InboundConnectionRequest.class);
            return inboundConnectionRequest;
        }
    }

    public void removeConnection(Long userId) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/connection/user/{userId}/remove".replace("{userId}", Long.toString(userId))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(null);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.removeConnection(userId);
                }
            }
        }
    }

    private class UserId {
        private Long userId;

        public UserId() {
        }

        public UserId(Long userId) {
            this.userId = userId;
        }

        public Long getUserId() {
            return this.userId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }
    }
}

