/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.SymBotClient;
import clients.symphony.api.DatafeedClientV1;
import clients.symphony.api.DatafeedClientV2;
import clients.symphony.api.IDatafeedClient;
import clients.symphony.api.constants.DatafeedVersion;
import configuration.SymConfig;
import exceptions.SymClientException;
import java.util.List;
import model.DatafeedEvent;
import model.datafeed.DatafeedV2;

public final class DatafeedClient
implements IDatafeedClient {
    private final IDatafeedClient datafeedClient;

    public DatafeedClient(SymBotClient client) {
        SymConfig config = client.getConfig();
        this.datafeedClient = DatafeedVersion.V2 == DatafeedVersion.of(config.getDatafeedVersion()) ? new DatafeedClientV2(client) : new DatafeedClientV1(client);
    }

    @Override
    public String createDatafeed() throws SymClientException {
        return this.datafeedClient.createDatafeed();
    }

    @Override
    public List<DatafeedEvent> readDatafeed(String id, String ... ackId) throws SymClientException {
        return this.datafeedClient.readDatafeed(id, ackId);
    }

    @Override
    public List<DatafeedV2> listDatafeedId() throws SymClientException {
        return this.datafeedClient.listDatafeedId();
    }

    @Override
    public void deleteDatafeed(String id) throws SymClientException {
        this.datafeedClient.deleteDatafeed(id);
    }

    @Override
    public String getAckId() {
        return this.datafeedClient.getAckId();
    }
}

