/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.SymBotClient;
import clients.symphony.api.APIClient;
import clients.symphony.api.IDatafeedClient;
import configuration.SymConfig;
import configuration.SymLoadBalancedConfig;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import model.DatafeedEvent;
import model.DatafeedEventsList;
import model.StringId;
import model.datafeed.DatafeedV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DatafeedClientV1
extends APIClient
implements IDatafeedClient {
    private final Logger logger = LoggerFactory.getLogger(DatafeedClientV1.class);
    private SymBotClient botClient;
    private SymConfig config;

    public DatafeedClientV1(SymBotClient client) {
        this.botClient = client;
        this.config = client.getConfig();
    }

    /*
     * Loose catch block
     */
    @Override
    public String createDatafeed() throws SymClientException {
        Invocation.Builder builder = this.botClient.getAgentClient().target(this.config.getAgentUrl()).path("/agent/v4/datafeed/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        this.logger.info("Creating new datafeed for bot {}..", (Object)this.botClient.getBotUsername());
        Throwable throwable = null;
        try (Response response = builder.post(null);){
            block23: {
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) break block23;
                try {
                    this.handleError(response, this.botClient);
                    String string = this.createDatafeed();
                    return string;
                }
                catch (UnauthorizedException ex) {
                    String string;
                    block21: {
                        block22: {
                            this.logger.error("createDatafeed error ", (Throwable)ex);
                            string = null;
                            if (response == null) break block21;
                            if (throwable == null) break block22;
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block21;
                        }
                        response.close();
                    }
                    return string;
                }
            }
            StringId datafeedId = (StringId)response.readEntity(StringId.class);
            this.logger.info("Created new datafeed {} for bot {}", (Object)datafeedId.getId(), (Object)this.botClient.getBotUsername());
            if (this.botClient.getConfig().getReuseDatafeedID() == null || this.botClient.getConfig().getReuseDatafeedID().booleanValue()) {
                this.writeDatafeedIdToDisk(this.botClient.getConfig(), datafeedId.getId());
            }
            String string = datafeedId.getId();
            return string;
            {
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    private void writeDatafeedIdToDisk(SymConfig config, String datafeedId) {
        String agentHostPort = config.getAgentHost() + ":" + config.getAgentPort();
        try (FileWriter fw = new FileWriter(this.botClient.getDatafeedIdFile());){
            fw.write(datafeedId + "@" + agentHostPort);
            fw.flush();
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage());
        }
    }

    @Override
    public List<DatafeedEvent> readDatafeed(String id, String ... ackId) throws SymClientException {
        WebTarget webTarget = this.botClient.getAgentClient().target(this.config.getAgentUrl());
        Invocation.Builder builder = webTarget.path("/agent/v4/datafeed/{id}/read".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        List<DatafeedEvent> datafeedEvents = null;
        this.logger.debug("Reading datafeed {}", (Object)id);
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                this.logger.error("Datafeed read error for request: {}", (Object)webTarget.getUri());
                this.handleError(response, this.botClient);
            } else if (response.getStatusInfo().getFamily() == Response.Status.Family.CLIENT_ERROR) {
                ((SymLoadBalancedConfig)this.config).rotateAgent();
            } else {
                datafeedEvents = response.getStatus() == Response.Status.NO_CONTENT.getStatusCode() ? new ArrayList<DatafeedEvent>() : (List)response.readEntity(DatafeedEventsList.class);
            }
            ArrayList<DatafeedEvent> arrayList = datafeedEvents;
            return arrayList;
        }
    }

    @Override
    public List<DatafeedV2> listDatafeedId() {
        throw new UnsupportedOperationException("List Datafeed not supported in Datafeed v1");
    }

    @Override
    public void deleteDatafeed(String id) {
        throw new UnsupportedOperationException("Delete Datafeed not supported in Datafeed v1");
    }

    @Override
    public String getAckId() {
        throw new UnsupportedOperationException("AckId not supported in Datafeed v1");
    }
}

