/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.SymBotClient;
import clients.symphony.api.APIClient;
import clients.symphony.api.IDatafeedClient;
import configuration.SymConfig;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import model.DatafeedEvent;
import model.datafeed.DatafeedV2;
import model.datafeed.DatafeedV2EventList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DatafeedClientV2
extends APIClient
implements IDatafeedClient {
    private final Logger logger = LoggerFactory.getLogger(DatafeedClientV2.class);
    private SymBotClient botClient;
    private SymConfig config;
    private String ackId;

    public DatafeedClientV2(SymBotClient client) {
        this.botClient = client;
        this.config = client.getConfig();
        this.ackId = "";
    }

    @Override
    public String createDatafeed() throws SymClientException {
        Invocation.Builder builder = this.botClient.getAgentClient().target(this.config.getAgentUrl()).path("/agent/v5/datafeeds").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        this.logger.info("Create datafeed for bot {}..", (Object)this.botClient.getBotUsername());
        try (Response response = builder.post(null);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException e) {
                    String string = this.createDatafeed();
                    if (response != null) {
                        if (var3_3 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var3_3.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return string;
                }
                String e = null;
                return e;
            }
            DatafeedV2 datafeedId = (DatafeedV2)response.readEntity(DatafeedV2.class);
            this.logger.info("Created datafeed {} for bot {}", (Object)datafeedId.getId(), (Object)this.botClient.getBotUsername());
            String string = datafeedId.getId();
            return string;
        }
    }

    @Override
    public List<DatafeedEvent> readDatafeed(String datafeedId, String ... ackId) throws SymClientException {
        Invocation.Builder builder = this.botClient.getAgentClient().target(this.config.getAgentUrl()).path("/agent/v5/datafeeds/{id}/read".replace("{id}", datafeedId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        HashMap<String, String> query = new HashMap<String, String>();
        if (ackId.length == 0) {
            query.put("ackId", "");
        } else {
            query.put("ackId", ackId[0]);
        }
        try (Response response = builder.post(Entity.entity(query, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException e) {
                    List<DatafeedEvent> list = this.readDatafeed(datafeedId, ackId);
                    if (response != null) {
                        if (var6_6 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var6_6.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<DatafeedEvent> e = null;
                return e;
            }
            DatafeedV2EventList datafeedEventList = (DatafeedV2EventList)response.readEntity(DatafeedV2EventList.class);
            this.logger.debug("Read datafeed events from datafeed {} ...", (Object)datafeedId);
            this.ackId = datafeedEventList.getAckId();
            List<DatafeedEvent> list = datafeedEventList.getEvents();
            return list;
        }
    }

    @Override
    public List<DatafeedV2> listDatafeedId() {
        Invocation.Builder builder = this.botClient.getAgentClient().target(this.config.getAgentUrl()).path("/agent/v5/datafeeds").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        this.logger.info("Retrieving datafeeds for bot {}..", (Object)this.botClient.getBotUsername());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException e) {
                    List<DatafeedV2> list = this.listDatafeedId();
                    if (response != null) {
                        if (var3_3 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var3_3.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<DatafeedV2> e = null;
                return e;
            }
            List datafeeds = (List)response.readEntity((GenericType)new GenericType<List<DatafeedV2>>(){});
            if (datafeeds.isEmpty()) {
                this.logger.info("No datafeed was retrieved for bot {}", (Object)this.botClient.getBotUsername());
            } else {
                this.logger.info("Retrieved datafeed {} for bot {}", (Object)((DatafeedV2)datafeeds.get(0)).getId(), (Object)this.botClient.getBotUsername());
            }
            List list = datafeeds;
            return list;
        }
    }

    @Override
    public void deleteDatafeed(String id) {
        Invocation.Builder builder = this.botClient.getAgentClient().target(this.config.getAgentUrl()).path("/agent/v5/datafeeds/{id}".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        this.logger.info("Deleting datafeed {} for bot {}..", (Object)id, (Object)this.botClient.getBotUsername());
        try (Response response = builder.delete();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException e) {
                    this.deleteDatafeed(id);
                }
            } else {
                this.logger.info("Delete datafeeds {} for bot {} successfully", (Object)id, (Object)this.botClient.getBotUsername());
            }
        }
    }

    @Override
    public String getAckId() {
        return this.ackId;
    }
}

