/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import clients.symphony.api.constants.HttpMethod;
import clients.symphony.api.constants.QueryParameterNames;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import model.HealthcheckResponse;

public class HealthcheckClient
extends APIClient {
    private ISymClient botClient;

    public HealthcheckClient(ISymClient client) {
        this.botClient = client;
    }

    public HealthcheckResponse performHealthCheck() {
        boolean showFirehoseErrors = this.botClient.getConfig().isShowFirehoseErrors();
        if (showFirehoseErrors) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put(QueryParameterNames.SHOW_FIREHOSE_ERRORS.getName(), Boolean.TRUE);
            return this.doRequest("/agent/v2/HealthCheck", HttpMethod.GET, HealthcheckResponse.class, parameters);
        }
        return this.doRequest("/agent/v2/HealthCheck", HttpMethod.GET, HealthcheckResponse.class);
    }

    private <T> T doRequest(String path, HttpMethod method, Class<T> clazz) {
        return this.doRequest(path, method, clazz, null);
    }

    private <T> T doRequest(String path, HttpMethod method, Class<T> clazz, Map<String, Object> queryParams) {
        WebTarget webTarget = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path(path);
        if (queryParams != null) {
            for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
                webTarget = webTarget.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        Invocation.Builder builder = webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        try (Response response = builder.method(method.name());){
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                Object object = response.readEntity(clazz);
                return (T)object;
            }
            this.handleError(response, this.botClient);
            T t = null;
            return t;
        }
    }
}

