/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import model.InformationBarrierGroup;
import model.InformationBarrierGroupStatus;
import model.Policy;

public class InformationBarriersClient
extends APIClient {
    private ISymClient botClient;

    public InformationBarriersClient(ISymClient client) {
        this.botClient = client;
    }

    public List<InformationBarrierGroup> listGroups() throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/group/list").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<InformationBarrierGroup> list = this.listGroups();
                    if (response != null) {
                        if (var3_3 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var3_3.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<InformationBarrierGroup> list = null;
                return list;
            }
            List list = (List)response.readEntity((GenericType)new GenericType<List<InformationBarrierGroup>>(){});
            return list;
        }
    }

    public List<Long> listGroupMembers(String groupId) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/group/{gid}/membership/list".replace("{gid}", groupId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<Long> list = this.listGroupMembers(groupId);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<Long> list = null;
                return list;
            }
            List list = (List)response.readEntity((GenericType)new GenericType<List<Long>>(){});
            return list;
        }
    }

    public InformationBarrierGroupStatus addGroupMembers(String groupId, List<Long> members) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/group/{gid}/membership/add".replace("{gid}", groupId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity(members, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InformationBarrierGroupStatus informationBarrierGroupStatus = this.addGroupMembers(groupId, members);
                    if (response != null) {
                        if (var5_5 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return informationBarrierGroupStatus;
                }
                InformationBarrierGroupStatus informationBarrierGroupStatus = null;
                return informationBarrierGroupStatus;
            }
            InformationBarrierGroupStatus informationBarrierGroupStatus = (InformationBarrierGroupStatus)response.readEntity(InformationBarrierGroupStatus.class);
            return informationBarrierGroupStatus;
        }
    }

    public InformationBarrierGroupStatus removeGroupMembers(String groupId, List<Long> members) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/group/{gid}/membership/remove".replace("{gid}", groupId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity(members, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InformationBarrierGroupStatus informationBarrierGroupStatus = this.removeGroupMembers(groupId, members);
                    if (response != null) {
                        if (var5_5 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return informationBarrierGroupStatus;
                }
                InformationBarrierGroupStatus informationBarrierGroupStatus = null;
                return informationBarrierGroupStatus;
            }
            InformationBarrierGroupStatus informationBarrierGroupStatus = (InformationBarrierGroupStatus)response.readEntity(InformationBarrierGroupStatus.class);
            return informationBarrierGroupStatus;
        }
    }

    public List<Policy> listPolicies() throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/admin/policy/list").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<Policy> list = this.listPolicies();
                    if (response != null) {
                        if (var3_3 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var3_3.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<Policy> list = null;
                return list;
            }
            List list = (List)response.readEntity((GenericType)new GenericType<List<Policy>>(){});
            return list;
        }
    }
}

