/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import authentication.SymOBOUserRSAAuth;
import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import model.Attachment;
import model.ContentAttachment;
import model.FileAttachment;
import model.InboundMessage;
import model.InboundMessageList;
import model.InboundShare;
import model.MessageStatus;
import model.OutboundMessage;
import model.OutboundShare;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagesClient
extends APIClient {
    private ISymClient botClient;
    private boolean isKeyManTokenRequired;
    private final Logger logger = LoggerFactory.getLogger(MessagesClient.class);

    public MessagesClient(ISymClient client) {
        this.botClient = client;
        this.isKeyManTokenRequired = !(this.botClient.getSymAuth() instanceof SymOBOUserRSAAuth);
    }

    private ContentAttachment convertFileToContent(File file) {
        try {
            return new ContentAttachment(file.getName(), Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read file: " + file.getPath());
        }
    }

    /*
     * Exception decompiling
     */
    private InboundMessage sendMessage(String streamId, OutboundMessage message, boolean appendTags) throws SymClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 50[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InboundMessage sendMessage(String streamId, OutboundMessage message) throws SymClientException {
        return this.sendMessage(streamId, message, true);
    }

    public InboundMessage forwardMessage(String streamId, InboundMessage message) throws SymClientException {
        OutboundMessage outboundMessage = new OutboundMessage();
        outboundMessage.setMessage(message.getMessage());
        outboundMessage.setData(message.getData());
        return this.sendMessage(streamId, outboundMessage, false);
    }

    public InboundMessage sendTaggedMessage(String streamId, OutboundMessage message) throws SymClientException {
        return this.sendMessage(streamId, message, false);
    }

    public InboundMessage getMessageById(String messageId) {
        String cleanMessageId = messageId.replaceAll("=", "").replaceAll("/", "_").replaceAll("\\+", "-");
        WebTarget webTarget = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v1/message/{mid}".replace("{mid}", cleanMessageId));
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        if (this.isKeyManTokenRequired) {
            builder = builder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        }
        try (Response response = builder.get();){
            InboundMessage result;
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundMessage inboundMessage = this.getMessageById(messageId);
                    if (response != null) {
                        if (var7_6 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var7_6.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return inboundMessage;
                }
                InboundMessage inboundMessage = null;
                return inboundMessage;
            }
            if (response.getStatus() == 204) {
                InboundMessage inboundMessage = null;
                return inboundMessage;
            }
            InboundMessage inboundMessage = result = (InboundMessage)response.readEntity(InboundMessage.class);
            return inboundMessage;
        }
    }

    public List<InboundMessage> getMessagesFromStream(String streamId, long since, int skip, int limit) throws SymClientException {
        WebTarget webTarget = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v4/stream/{sid}/message".replace("{sid}", streamId)).queryParam("since", new Object[]{since});
        if (skip > 0) {
            webTarget = webTarget.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            webTarget = webTarget.queryParam("limit", new Object[]{limit});
        }
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        if (this.isKeyManTokenRequired) {
            builder = builder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        }
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<InboundMessage> list = this.getMessagesFromStream(streamId, since, skip, limit);
                    if (response != null) {
                        if (var10_8 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var10_8.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<InboundMessage> list = null;
                return list;
            }
            List result = response.getStatus() == 204 ? new ArrayList() : (List)response.readEntity(InboundMessageList.class);
            ArrayList<InboundMessage> arrayList = result;
            return arrayList;
        }
    }

    public byte[] getAttachment(String streamId, String attachmentId, String messageId) throws SymClientException {
        Invocation.Builder subBuilder = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v1/stream/{sid}/attachment".replace("{sid}", streamId)).queryParam("fileId", new Object[]{attachmentId}).queryParam("messageId", new Object[]{messageId}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        if (this.isKeyManTokenRequired) {
            subBuilder = subBuilder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        }
        try (Response response = subBuilder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    byte[] byArray = this.getAttachment(streamId, attachmentId, messageId);
                    if (response != null) {
                        if (var6_6 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var6_6.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return byArray;
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = Base64.getDecoder().decode((String)response.readEntity(String.class));
            return byArray;
        }
    }

    public List<FileAttachment> getMessageAttachments(InboundMessage message) throws SymClientException {
        ArrayList<FileAttachment> result = new ArrayList<FileAttachment>();
        if (message.getAttachments() != null) {
            for (Attachment attachment : message.getAttachments()) {
                FileAttachment fileAttachment = new FileAttachment();
                fileAttachment.setFileName(attachment.getName());
                fileAttachment.setSize(attachment.getSize());
                fileAttachment.setFileContent(this.getAttachment(message.getStream().getStreamId(), attachment.getId(), message.getMessageId()));
                result.add(fileAttachment);
            }
        }
        return result;
    }

    public MessageStatus getMessageStatus(String messageId) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/message/{mid}/status".replace("{mid}", messageId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    MessageStatus messageStatus = this.getMessageStatus(messageId);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return messageStatus;
                }
                MessageStatus messageStatus = null;
                return messageStatus;
            }
            MessageStatus messageStatus = (MessageStatus)response.readEntity(MessageStatus.class);
            return messageStatus;
        }
    }

    public InboundMessageList messageSearch(Map<String, String> query, int skip, int limit, boolean orderAscending) throws SymClientException, NoContentException {
        WebTarget webTarget = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v1/message/search");
        if (skip > 0) {
            webTarget = webTarget.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            webTarget = webTarget.queryParam("limit", new Object[]{limit});
        }
        if (orderAscending) {
            webTarget = webTarget.queryParam("sortDir", new Object[]{"ASC"});
        }
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        if (this.isKeyManTokenRequired) {
            builder = builder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        }
        try (Response response = builder.post(Entity.entity(query, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundMessageList inboundMessageList = this.messageSearch(query, skip, limit, orderAscending);
                    if (response != null) {
                        if (var8_8 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var8_8.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return inboundMessageList;
                }
                InboundMessageList inboundMessageList = null;
                return inboundMessageList;
            }
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                throw new NoContentException("No messages found");
            }
            InboundMessageList inboundMessageList = (InboundMessageList)response.readEntity(InboundMessageList.class);
            return inboundMessageList;
        }
    }

    public InboundShare shareContent(String streamId, OutboundShare shareContent) throws SymClientException {
        HashMap<String, OutboundShare> map = new HashMap<String, OutboundShare>();
        map.put("content", shareContent);
        Invocation.Builder builder = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v3/stream/{sid}/share".replace("{sid}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        if (this.isKeyManTokenRequired) {
            builder = builder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        }
        try (Response response = builder.post(Entity.entity(map, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundShare inboundShare = this.shareContent(streamId, shareContent);
                    if (response != null) {
                        if (var6_6 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var6_6.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return inboundShare;
                }
                InboundShare inboundShare = null;
                return inboundShare;
            }
            InboundShare inboundShare = (InboundShare)response.readEntity(InboundShare.class);
            return inboundShare;
        }
    }
}

