/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import model.UserPresence;
import model.UserPresenceCategory;

public class PresenceClient
extends APIClient {
    private final ISymClient botClient;

    public UserPresence getUserPresence(@Nonnull Long userId, boolean local) throws SymClientException {
        Invocation.Builder builder = this.getTarget().path("/pod/v3/user/{uid}/presence".replace("{uid}", Long.toString(userId))).queryParam("local", new Object[]{local}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    UserPresence userPresence = this.getUserPresence(userId, local);
                    if (response != null) {
                        if (var5_5 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return userPresence;
                }
                UserPresence userPresence = null;
                return userPresence;
            }
            UserPresence userPresence = (UserPresence)response.readEntity(UserPresence.class);
            return userPresence;
        }
    }

    public UserPresence getUserPresence() throws SymClientException {
        Invocation.Builder builder = this.getTarget().path("/pod/v2/user/presence").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    UserPresence userPresence = this.getUserPresence();
                    if (response != null) {
                        if (var3_3 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var3_3.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return userPresence;
                }
                UserPresence userPresence = null;
                return userPresence;
            }
            UserPresence userPresence = (UserPresence)response.readEntity(UserPresence.class);
            return userPresence;
        }
    }

    public List<UserPresence> getAllPresence(@Nullable Long lastUserId, @Nullable Integer limit) throws SymClientException {
        WebTarget target = this.getTarget();
        if (lastUserId != null) {
            target = target.queryParam("lastUserId", new Object[]{lastUserId});
        }
        if (limit != null) {
            if (limit > 5000) {
                throw new IllegalArgumentException("The maximum supported value for the limit is 5000.");
            }
            target = target.queryParam("limit", new Object[]{limit});
        }
        Invocation.Builder builder = target.path("/pod/v2/users/presence").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<UserPresence> list = this.getAllPresence(lastUserId, limit);
                    if (response != null) {
                        if (var6_6 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var6_6.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<UserPresence> list = null;
                return list;
            }
            List list = (List)response.readEntity((GenericType)new GenericType<List<UserPresence>>(){});
            return list;
        }
    }

    public UserPresence setPresence(@Nonnull UserPresenceCategory category) throws SymClientException {
        Invocation.Builder builder = this.getTarget().path("/pod/v2/user/presence").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)new Category(category), (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    UserPresence userPresence = this.setPresence(category);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return userPresence;
                }
                UserPresence userPresence = null;
                return userPresence;
            }
            UserPresence userPresence = (UserPresence)response.readEntity(UserPresence.class);
            return userPresence;
        }
    }

    @Deprecated
    public UserPresence setPresence(@Nonnull String status) throws SymClientException {
        return this.setPresence(UserPresenceCategory.valueOf(status));
    }

    public void registerInterestExtUser(@Nonnull List<Long> userIds) throws SymClientException {
        Invocation.Builder builder = this.getTarget().path("/pod/v1/user/presence/register").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity(userIds, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.registerInterestExtUser(userIds);
                }
            }
        }
    }

    public String createPresenceFeed() throws SymClientException {
        Invocation.Builder builder = this.getTarget().path("/pod/v1/presence/feed/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)"{}", (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    String string = this.createPresenceFeed();
                    if (response != null) {
                        if (var3_3 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var3_3.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return string;
                }
                String string = null;
                return string;
            }
            String string = ((PresenceFeedCreationResponse)response.readEntity(PresenceFeedCreationResponse.class)).getId();
            return string;
        }
    }

    public List<UserPresence> readPresenceFeed(@Nonnull String feedId) throws SymClientException {
        Invocation.Builder builder = this.getTarget().path("/pod/v1/presence/feed/{feedId}/read".replace("{feedId}", feedId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)"{}", (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<UserPresence> list = this.readPresenceFeed(feedId);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<UserPresence> list = null;
                return list;
            }
            List list = (List)response.readEntity((GenericType)new GenericType<List<UserPresence>>(){});
            return list;
        }
    }

    public void deletePresenceFeed(@Nonnull String feedId) throws SymClientException {
        Invocation.Builder builder = this.getTarget().path("/pod/v1/presence/feed/{feedId}/read".replace("{feedId}", feedId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.delete();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.deletePresenceFeed(feedId);
                }
            }
        }
    }

    public UserPresence setOtherUserPresence(@Nonnull Long userId, @Nonnull UserPresenceCategory category) throws SymClientException {
        Invocation.Builder builder = this.getTarget().path("/pod/v3/user/presence").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        OtherUserPresenceRequest otherUserPresenceRequest = new OtherUserPresenceRequest(userId, category);
        try (Response response = builder.post(Entity.entity((Object)otherUserPresenceRequest, (MediaType)MediaType.APPLICATION_JSON_TYPE));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    UserPresence userPresence = this.setOtherUserPresence(userId, category);
                    if (response != null) {
                        if (var6_6 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var6_6.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return userPresence;
                }
                UserPresence userPresence = null;
                return userPresence;
            }
            UserPresence userPresence = (UserPresence)response.readEntity(UserPresence.class);
            return userPresence;
        }
    }

    private WebTarget getTarget() {
        return this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl());
    }

    public PresenceClient(ISymClient botClient) {
        this.botClient = botClient;
    }

    private static class Category {
        private UserPresenceCategory category;

        public UserPresenceCategory getCategory() {
            return this.category;
        }

        public void setCategory(UserPresenceCategory category) {
            this.category = category;
        }

        public Category() {
        }

        public Category(UserPresenceCategory category) {
            this.category = category;
        }
    }

    private static class PresenceFeedCreationResponse {
        private String id;

        private PresenceFeedCreationResponse() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    private static class OtherUserPresenceRequest {
        private Long userId;
        private UserPresenceCategory category;

        public Long getUserId() {
            return this.userId;
        }

        public UserPresenceCategory getCategory() {
            return this.category;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public void setCategory(UserPresenceCategory category) {
            this.category = category;
        }

        public OtherUserPresenceRequest() {
        }

        public OtherUserPresenceRequest(Long userId, UserPresenceCategory category) {
            this.userId = userId;
            this.category = category;
        }
    }
}

