/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import authentication.SymOBOUserRSAAuth;
import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import model.Signal;
import model.SignalList;
import model.SignalSubscriberList;
import model.SignalSubscriptionResult;

public class SignalsClient
extends APIClient {
    private ISymClient botClient;
    private boolean isKeyManTokenRequired;

    public SignalsClient(ISymClient client) {
        this.botClient = client;
        this.isKeyManTokenRequired = !(this.botClient.getSymAuth() instanceof SymOBOUserRSAAuth);
    }

    public List<Signal> listSignals(int skip, int limit) throws SymClientException {
        WebTarget webTarget = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v1/signals/list");
        if (skip > 0) {
            webTarget = webTarget.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            webTarget = webTarget.queryParam("limit", new Object[]{limit});
        }
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        if (this.isKeyManTokenRequired) {
            builder = builder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        }
        try (Response response = builder.get();){
            if (response.getStatus() == 204) {
                ArrayList<Signal> arrayList = new ArrayList<Signal>();
                return arrayList;
            }
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<Signal> list = this.listSignals(skip, limit);
                    if (response != null) {
                        if (var6_6 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var6_6.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<Signal> list = null;
                return list;
            }
            List list = (List)response.readEntity(SignalList.class);
            return list;
        }
    }

    public Signal getSignal(String id) throws SymClientException {
        Invocation.Builder builder = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v1/signals/{id}/get".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        if (this.isKeyManTokenRequired) {
            builder = builder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        }
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    Signal signal = this.getSignal(id);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return signal;
                }
                Signal signal = null;
                return signal;
            }
            Signal signal = (Signal)response.readEntity(Signal.class);
            return signal;
        }
    }

    public Signal createSignal(Signal signal) throws SymClientException {
        Invocation.Builder builder = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v1/signals/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        if (this.isKeyManTokenRequired) {
            builder = builder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        }
        try (Response response = builder.post(Entity.entity((Object)signal, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    Signal signal2 = this.createSignal(signal);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return signal2;
                }
                Signal signal3 = null;
                return signal3;
            }
            Signal signal4 = (Signal)response.readEntity(Signal.class);
            return signal4;
        }
    }

    public Signal updateSignal(Signal signal) throws SymClientException {
        Invocation.Builder builder = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v1/signals/{id}/update".replace("{id}", signal.getId())).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        try (Response response = builder.post(Entity.entity((Object)signal, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    Signal signal2 = this.updateSignal(signal);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return signal2;
                }
                Signal signal3 = null;
                return signal3;
            }
            Signal signal4 = (Signal)response.readEntity(Signal.class);
            return signal4;
        }
    }

    public void deleteSignal(String id) throws SymClientException {
        Invocation.Builder builder = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v1/signals/{id}/delete".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        try (Response response = builder.post(null);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.deleteSignal(id);
                }
            }
        }
    }

    public SignalSubscriptionResult subscribeSignal(String id, boolean self, List<Long> uids, boolean pushed) throws SymClientException {
        WebTarget webTarget = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v1/signals/{id}/subscribe".replace("{id}", id));
        Entity entity = null;
        if (self) {
            webTarget = webTarget.queryParam("pushed", new Object[]{pushed});
            entity = Entity.entity(uids, (String)"application/json");
        }
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        try (Response response = builder.post(entity);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.subscribeSignal(id, self, uids, pushed);
                }
            }
            SignalSubscriptionResult signalSubscriptionResult = (SignalSubscriptionResult)response.readEntity(SignalSubscriptionResult.class);
            return signalSubscriptionResult;
        }
    }

    /*
     * Loose catch block
     */
    public SignalSubscriptionResult unsubscribeSignal(String id, boolean self, List<Long> uids) throws SymClientException {
        Entity entity = self ? Entity.entity(uids, (String)"application/json") : null;
        Invocation.Builder builder = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v1/signals/{id}/unsubscribe".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        Throwable throwable = null;
        try (Response response = builder.post(entity);){
            block22: {
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) break block22;
                try {
                    this.handleError(response, this.botClient);
                    SignalSubscriptionResult signalSubscriptionResult = null;
                    return signalSubscriptionResult;
                }
                catch (UnauthorizedException ex) {
                    SignalSubscriptionResult signalSubscriptionResult;
                    block20: {
                        block21: {
                            signalSubscriptionResult = this.unsubscribeSignal(id, self, uids);
                            if (response == null) break block20;
                            if (throwable == null) break block21;
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block20;
                        }
                        response.close();
                    }
                    return signalSubscriptionResult;
                }
            }
            SignalSubscriptionResult signalSubscriptionResult = (SignalSubscriptionResult)response.readEntity(SignalSubscriptionResult.class);
            return signalSubscriptionResult;
            {
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    public SignalSubscriberList getSignalSubscribers(String id, int skip, int limit) throws SymClientException {
        WebTarget webTarget = this.botClient.getAgentClient().target(this.botClient.getConfig().getAgentUrl()).path("/agent/v1/signals/{id}/subscribers".replace("{id}", id));
        if (skip > 0) {
            webTarget = webTarget.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            webTarget = webTarget.queryParam("limit", new Object[]{limit});
        }
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    SignalSubscriberList signalSubscriberList = this.getSignalSubscribers(id, skip, limit);
                    if (response != null) {
                        if (var7_7 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var7_7.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return signalSubscriberList;
                }
                SignalSubscriberList signalSubscriberList = null;
                return signalSubscriberList;
            }
            SignalSubscriberList signalSubscriberList = (SignalSubscriberList)response.readEntity(SignalSubscriberList.class);
            return signalSubscriberList;
        }
    }
}

