/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import model.MemberList;
import model.NumericId;
import model.Room;
import model.RoomInfo;
import model.RoomMember;
import model.RoomSearchQuery;
import model.RoomSearchResult;
import model.StreamInfo;
import model.StreamInfoList;
import model.StreamListItem;
import model.StringId;

public class StreamsClient
extends APIClient {
    private ISymClient botClient;

    public StreamsClient(ISymClient client) {
        this.botClient = client;
    }

    public String getUserIMStreamId(Long userId) throws SymClientException {
        ArrayList<Long> userIdList = new ArrayList<Long>();
        userIdList.add(userId);
        return this.getUserListIM(userIdList);
    }

    public String getUserListIM(List<Long> userIdList) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/im/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity(userIdList, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    String string = this.getUserListIM(userIdList);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return string;
                }
                String string = null;
                return string;
            }
            String string = ((StringId)response.readEntity(StringId.class)).getId();
            return string;
        }
    }

    public RoomInfo createRoom(Room room) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v3/room/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)room, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    RoomInfo roomInfo = this.createRoom(room);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return roomInfo;
                }
                RoomInfo roomInfo = null;
                return roomInfo;
            }
            RoomInfo roomInfo = (RoomInfo)response.readEntity(RoomInfo.class);
            return roomInfo;
        }
    }

    public void addMemberToRoom(String streamId, Long userId) throws SymClientException {
        NumericId id = new NumericId(userId);
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/room/{id}/membership/add".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)id, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.addMemberToRoom(streamId, userId);
                }
            }
        }
    }

    public void removeMemberFromRoom(String streamId, Long userId) throws SymClientException {
        NumericId id = new NumericId(userId);
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/room/{id}/membership/remove".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)id, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.removeMemberFromRoom(streamId, userId);
                }
            }
        }
    }

    public RoomInfo getRoomInfo(String streamId) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v3/room/{id}/info".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    RoomInfo roomInfo = this.getRoomInfo(streamId);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return roomInfo;
                }
                RoomInfo roomInfo = null;
                return roomInfo;
            }
            RoomInfo roomInfo = (RoomInfo)response.readEntity(RoomInfo.class);
            return roomInfo;
        }
    }

    public RoomInfo updateRoom(String streamId, Room room) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v3/room/{id}/update".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)room, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    RoomInfo roomInfo = this.updateRoom(streamId, room);
                    if (response != null) {
                        if (var5_5 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return roomInfo;
                }
                RoomInfo roomInfo = null;
                return roomInfo;
            }
            RoomInfo roomInfo = (RoomInfo)response.readEntity(RoomInfo.class);
            return roomInfo;
        }
    }

    public StreamInfo getStreamInfo(String streamId) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v2/streams/{id}/info".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    StreamInfo streamInfo = this.getStreamInfo(streamId);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return streamInfo;
                }
                StreamInfo streamInfo = null;
                return streamInfo;
            }
            StreamInfo streamInfo = (StreamInfo)response.readEntity(StreamInfo.class);
            return streamInfo;
        }
    }

    public List<RoomMember> getRoomMembers(String streamId) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v2/room/{id}/membership/list".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.get();){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<RoomMember> list = this.getRoomMembers(streamId);
                    if (response != null) {
                        if (var4_4 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<RoomMember> list = null;
                return list;
            }
            List list = (List)response.readEntity(MemberList.class);
            return list;
        }
    }

    public void activateRoom(String streamId) throws SymClientException {
        this.setActiveRoom(streamId, true);
    }

    public void deactivateRoom(String streamId) throws SymClientException {
        this.setActiveRoom(streamId, false);
    }

    private void setActiveRoom(String streamId, boolean active) throws SymClientException {
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/room/{id}/setActive".replace("{id}", streamId)).queryParam("active", new Object[]{active}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(null);){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.setActiveRoom(streamId, active);
                }
            }
        }
    }

    public void promoteUserToOwner(String streamId, Long userId) throws SymClientException {
        NumericId id = new NumericId(userId);
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/room/{id}/membership/promoteOwner".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)id, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.promoteUserToOwner(streamId, userId);
                }
            }
        }
    }

    public void demoteUserFromOwner(String streamId, Long userId) throws SymClientException {
        NumericId id = new NumericId(userId);
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/room/{id}/membership/demoteOwner".replace("{id}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)id, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.demoteUserFromOwner(streamId, userId);
                }
            }
        }
    }

    public RoomSearchResult searchRooms(RoomSearchQuery query, int skip, int limit) throws SymClientException, NoContentException {
        WebTarget webTarget = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v3/room/search");
        if (skip > 0) {
            webTarget = webTarget.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            webTarget = webTarget.queryParam("limit", new Object[]{limit});
        }
        if (query.getLabels() == null) {
            query.setLabels(new ArrayList<String>());
        }
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity((Object)query, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    RoomSearchResult roomSearchResult = this.searchRooms(query, skip, limit);
                    if (response != null) {
                        if (var7_7 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var7_7.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return roomSearchResult;
                }
                RoomSearchResult roomSearchResult = null;
                return roomSearchResult;
            }
            if (response.getStatus() == 204) {
                throw new NoContentException("No messages found");
            }
            RoomSearchResult roomSearchResult = (RoomSearchResult)response.readEntity(RoomSearchResult.class);
            return roomSearchResult;
        }
    }

    public List<StreamListItem> getUserStreams(List<String> streamTypes, boolean includeInactiveStreams) throws SymClientException {
        return this.getUserStreams(streamTypes, includeInactiveStreams, 0, 50);
    }

    public List<StreamListItem> getUserStreams(List<String> streamTypes, boolean includeInactiveStreams, int skip, int limit) throws SymClientException {
        if (skip < 0) {
            throw new IllegalArgumentException("skip must be equal or greater than 0.");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be equal or greater than 0.");
        }
        ArrayList inputStreamTypes = new ArrayList();
        if (streamTypes != null) {
            for (String type : streamTypes) {
                HashMap<String, String> streamTypesMap = new HashMap<String, String>();
                streamTypesMap.put("type", type);
                inputStreamTypes.add(streamTypesMap);
            }
        }
        HashMap<String, Serializable> input = new HashMap<String, Serializable>();
        input.put("streamTypes", inputStreamTypes);
        input.put("includeInactiveStreams", Boolean.valueOf(includeInactiveStreams));
        Invocation.Builder builder = this.botClient.getPodClient().target(this.botClient.getConfig().getPodUrl()).path("/pod/v1/streams/list").queryParam("skip", new Object[]{skip}).queryParam("limit", new Object[]{limit}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        try (Response response = builder.post(Entity.entity(input, (String)"application/json"));){
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<StreamListItem> list = this.getUserStreams(streamTypes, includeInactiveStreams);
                    if (response != null) {
                        if (var9_9 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable) {
                                var9_9.addSuppressed(throwable);
                            }
                        } else {
                            response.close();
                        }
                    }
                    return list;
                }
                List<StreamListItem> list = null;
                return list;
            }
            List list = (List)response.readEntity(StreamInfoList.class);
            return list;
        }
    }

    public StreamListItem getUserWallStream() throws SymClientException {
        ArrayList<String> streamTypes = new ArrayList<String>();
        streamTypes.add("POST");
        return this.getUserStreams(streamTypes, false).get(0);
    }
}

