/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import configuration.RetryConfiguration;
import java.io.File;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SymConfig {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_READ_TIMEOUT = 35000;
    private String sessionAuthHost;
    private int sessionAuthPort;
    private String sessionAuthContextPath;
    private String keyAuthHost;
    private int keyAuthPort;
    private String keyAuthContextPath;
    private String keyManagerProxyURL;
    private String keyManagerProxyUsername;
    private String keyManagerProxyPassword;
    private String podHost;
    private int podPort;
    private String podContextPath;
    private String podProxyURL;
    private String podProxyUsername;
    private String podProxyPassword;
    private String agentHost;
    private int agentPort;
    private String agentContextPath;
    private String agentProxyURL;
    private String agentProxyUsername;
    private String agentProxyPassword;
    private String proxyURL;
    private String proxyUsername;
    private String proxyPassword;
    private int connectionTimeout = 10000;
    private int readTimeout = 35000;
    private String botUsername;
    private String botEmailAddress;
    private String botPrivateKeyPath;
    private String botPrivateKeyName;
    private String botCertPath;
    private String botCertName;
    private String botCertPassword;
    private String appId;
    private String appPrivateKeyPath;
    private String appPrivateKeyName;
    private String appCertPath;
    private String appCertName;
    private String appCertPassword;
    private String truststorePath;
    private String truststorePassword;
    private String datafeedVersion;
    private int datafeedEventsThreadpoolSize;
    private int datafeedEventsErrorTimeout;
    private Boolean reuseDatafeedID;
    private String datafeedIdFilePath;
    private String authenticationFilterUrlPattern;
    private boolean showFirehoseErrors;
    private ArrayList<String> supportedUriSchemes = new ArrayList();
    private RetryConfiguration retry = new RetryConfiguration();

    public String getAgentUrl() {
        String port = this.getAgentPort() == 443 ? "" : ":" + this.getAgentPort();
        String contextPath = this.formatContextPath(this.getAgentContextPath());
        return "https://" + this.getAgentHost() + port + contextPath;
    }

    public String getPodUrl() {
        String port = this.getPodPort() == 443 ? "" : ":" + this.getPodPort();
        String contextPath = this.formatContextPath(this.getPodContextPath());
        return "https://" + this.getPodHost() + port + contextPath;
    }

    public String getKeyAuthUrl() {
        String port = this.getKeyAuthPort() == 443 ? "" : ":" + this.getKeyAuthPort();
        String contextPath = this.formatContextPath(this.getKeyAuthContextPath());
        return "https://" + this.getKeyAuthHost() + port + contextPath;
    }

    public String getSessionAuthUrl() {
        String port = this.getSessionAuthPort() == 443 ? "" : ":" + this.getSessionAuthPort();
        String contextPath = this.formatContextPath(this.getSessionAuthContextPath());
        return "https://" + this.getSessionAuthHost() + port + contextPath;
    }

    public String getDatafeedIdFilePath() {
        if (this.datafeedIdFilePath == null || this.datafeedIdFilePath.isEmpty()) {
            return "." + File.separator;
        }
        if (!this.datafeedIdFilePath.endsWith(File.separator)) {
            return this.datafeedIdFilePath + File.separator;
        }
        return this.datafeedIdFilePath;
    }

    private String formatContextPath(String contextPath) {
        String formattedPath;
        String string = formattedPath = contextPath == null ? "" : contextPath;
        if (!formattedPath.equals("") && formattedPath.charAt(0) != '/') {
            formattedPath = "/" + formattedPath;
        }
        if (!formattedPath.equals("") && formattedPath.endsWith("/")) {
            formattedPath = formattedPath.substring(0, formattedPath.length() - 1);
        }
        return formattedPath;
    }

    public int getDatafeedEventsThreadpoolSize() {
        return this.datafeedEventsThreadpoolSize > 0 ? this.datafeedEventsThreadpoolSize : 5;
    }

    public int getDatafeedEventsErrorTimeout() {
        return this.datafeedEventsErrorTimeout > 0 ? this.datafeedEventsErrorTimeout : 30;
    }

    public String getSessionAuthHost() {
        return this.sessionAuthHost;
    }

    public int getSessionAuthPort() {
        return this.sessionAuthPort;
    }

    public String getSessionAuthContextPath() {
        return this.sessionAuthContextPath;
    }

    public String getKeyAuthHost() {
        return this.keyAuthHost;
    }

    public int getKeyAuthPort() {
        return this.keyAuthPort;
    }

    public String getKeyAuthContextPath() {
        return this.keyAuthContextPath;
    }

    public String getKeyManagerProxyURL() {
        return this.keyManagerProxyURL;
    }

    public String getKeyManagerProxyUsername() {
        return this.keyManagerProxyUsername;
    }

    public String getKeyManagerProxyPassword() {
        return this.keyManagerProxyPassword;
    }

    public String getPodHost() {
        return this.podHost;
    }

    public int getPodPort() {
        return this.podPort;
    }

    public String getPodContextPath() {
        return this.podContextPath;
    }

    public String getPodProxyURL() {
        return this.podProxyURL;
    }

    public String getPodProxyUsername() {
        return this.podProxyUsername;
    }

    public String getPodProxyPassword() {
        return this.podProxyPassword;
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public String getAgentContextPath() {
        return this.agentContextPath;
    }

    public String getAgentProxyURL() {
        return this.agentProxyURL;
    }

    public String getAgentProxyUsername() {
        return this.agentProxyUsername;
    }

    public String getAgentProxyPassword() {
        return this.agentProxyPassword;
    }

    public String getProxyURL() {
        return this.proxyURL;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getBotUsername() {
        return this.botUsername;
    }

    public String getBotEmailAddress() {
        return this.botEmailAddress;
    }

    public String getBotPrivateKeyPath() {
        return this.botPrivateKeyPath;
    }

    public String getBotPrivateKeyName() {
        return this.botPrivateKeyName;
    }

    public String getBotCertPath() {
        return this.botCertPath;
    }

    public String getBotCertName() {
        return this.botCertName;
    }

    public String getBotCertPassword() {
        return this.botCertPassword;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppPrivateKeyPath() {
        return this.appPrivateKeyPath;
    }

    public String getAppPrivateKeyName() {
        return this.appPrivateKeyName;
    }

    public String getAppCertPath() {
        return this.appCertPath;
    }

    public String getAppCertName() {
        return this.appCertName;
    }

    public String getAppCertPassword() {
        return this.appCertPassword;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getDatafeedVersion() {
        return this.datafeedVersion;
    }

    public Boolean getReuseDatafeedID() {
        return this.reuseDatafeedID;
    }

    public String getAuthenticationFilterUrlPattern() {
        return this.authenticationFilterUrlPattern;
    }

    public boolean isShowFirehoseErrors() {
        return this.showFirehoseErrors;
    }

    public ArrayList<String> getSupportedUriSchemes() {
        return this.supportedUriSchemes;
    }

    public RetryConfiguration getRetry() {
        return this.retry;
    }

    public void setSessionAuthHost(String sessionAuthHost) {
        this.sessionAuthHost = sessionAuthHost;
    }

    public void setSessionAuthPort(int sessionAuthPort) {
        this.sessionAuthPort = sessionAuthPort;
    }

    public void setSessionAuthContextPath(String sessionAuthContextPath) {
        this.sessionAuthContextPath = sessionAuthContextPath;
    }

    public void setKeyAuthHost(String keyAuthHost) {
        this.keyAuthHost = keyAuthHost;
    }

    public void setKeyAuthPort(int keyAuthPort) {
        this.keyAuthPort = keyAuthPort;
    }

    public void setKeyAuthContextPath(String keyAuthContextPath) {
        this.keyAuthContextPath = keyAuthContextPath;
    }

    public void setKeyManagerProxyURL(String keyManagerProxyURL) {
        this.keyManagerProxyURL = keyManagerProxyURL;
    }

    public void setKeyManagerProxyUsername(String keyManagerProxyUsername) {
        this.keyManagerProxyUsername = keyManagerProxyUsername;
    }

    public void setKeyManagerProxyPassword(String keyManagerProxyPassword) {
        this.keyManagerProxyPassword = keyManagerProxyPassword;
    }

    public void setPodHost(String podHost) {
        this.podHost = podHost;
    }

    public void setPodPort(int podPort) {
        this.podPort = podPort;
    }

    public void setPodContextPath(String podContextPath) {
        this.podContextPath = podContextPath;
    }

    public void setPodProxyURL(String podProxyURL) {
        this.podProxyURL = podProxyURL;
    }

    public void setPodProxyUsername(String podProxyUsername) {
        this.podProxyUsername = podProxyUsername;
    }

    public void setPodProxyPassword(String podProxyPassword) {
        this.podProxyPassword = podProxyPassword;
    }

    public void setAgentHost(String agentHost) {
        this.agentHost = agentHost;
    }

    public void setAgentPort(int agentPort) {
        this.agentPort = agentPort;
    }

    public void setAgentContextPath(String agentContextPath) {
        this.agentContextPath = agentContextPath;
    }

    public void setAgentProxyURL(String agentProxyURL) {
        this.agentProxyURL = agentProxyURL;
    }

    public void setAgentProxyUsername(String agentProxyUsername) {
        this.agentProxyUsername = agentProxyUsername;
    }

    public void setAgentProxyPassword(String agentProxyPassword) {
        this.agentProxyPassword = agentProxyPassword;
    }

    public void setProxyURL(String proxyURL) {
        this.proxyURL = proxyURL;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setBotUsername(String botUsername) {
        this.botUsername = botUsername;
    }

    public void setBotEmailAddress(String botEmailAddress) {
        this.botEmailAddress = botEmailAddress;
    }

    public void setBotPrivateKeyPath(String botPrivateKeyPath) {
        this.botPrivateKeyPath = botPrivateKeyPath;
    }

    public void setBotPrivateKeyName(String botPrivateKeyName) {
        this.botPrivateKeyName = botPrivateKeyName;
    }

    public void setBotCertPath(String botCertPath) {
        this.botCertPath = botCertPath;
    }

    public void setBotCertName(String botCertName) {
        this.botCertName = botCertName;
    }

    public void setBotCertPassword(String botCertPassword) {
        this.botCertPassword = botCertPassword;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppPrivateKeyPath(String appPrivateKeyPath) {
        this.appPrivateKeyPath = appPrivateKeyPath;
    }

    public void setAppPrivateKeyName(String appPrivateKeyName) {
        this.appPrivateKeyName = appPrivateKeyName;
    }

    public void setAppCertPath(String appCertPath) {
        this.appCertPath = appCertPath;
    }

    public void setAppCertName(String appCertName) {
        this.appCertName = appCertName;
    }

    public void setAppCertPassword(String appCertPassword) {
        this.appCertPassword = appCertPassword;
    }

    public void setTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public void setDatafeedVersion(String datafeedVersion) {
        this.datafeedVersion = datafeedVersion;
    }

    public void setDatafeedEventsThreadpoolSize(int datafeedEventsThreadpoolSize) {
        this.datafeedEventsThreadpoolSize = datafeedEventsThreadpoolSize;
    }

    public void setDatafeedEventsErrorTimeout(int datafeedEventsErrorTimeout) {
        this.datafeedEventsErrorTimeout = datafeedEventsErrorTimeout;
    }

    public void setReuseDatafeedID(Boolean reuseDatafeedID) {
        this.reuseDatafeedID = reuseDatafeedID;
    }

    public void setDatafeedIdFilePath(String datafeedIdFilePath) {
        this.datafeedIdFilePath = datafeedIdFilePath;
    }

    public void setAuthenticationFilterUrlPattern(String authenticationFilterUrlPattern) {
        this.authenticationFilterUrlPattern = authenticationFilterUrlPattern;
    }

    public void setShowFirehoseErrors(boolean showFirehoseErrors) {
        this.showFirehoseErrors = showFirehoseErrors;
    }

    public void setSupportedUriSchemes(ArrayList<String> supportedUriSchemes) {
        this.supportedUriSchemes = supportedUriSchemes;
    }

    public void setRetry(RetryConfiguration retry) {
        this.retry = retry;
    }
}

