/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import configuration.SymConfig;
import configuration.SymLoadBalancedConfig;
import exceptions.NoConfigException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymConfigLoader {
    private static final Logger logger = LoggerFactory.getLogger(SymConfigLoader.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static SymConfig loadFromFile(String path) {
        return SymConfigLoader.loadFromFile(path, SymConfig.class);
    }

    public static <T extends SymConfig> T loadFromFile(String path, Class<T> clazz) {
        try {
            return (T)((SymConfig)mapper.readValue(new File(path), clazz));
        }
        catch (IOException e) {
            logger.error("Unable to load config file: " + path, (Throwable)e);
            return null;
        }
    }

    public static SymConfig load(InputStream inputStream) {
        return SymConfigLoader.load(inputStream, SymConfig.class);
    }

    public static <T extends SymConfig> T load(InputStream inputStream, Class<T> clazz) {
        try {
            return (T)((SymConfig)mapper.readValue(inputStream, clazz));
        }
        catch (IOException e) {
            logger.error("Unable to load config", (Throwable)e);
            return null;
        }
    }

    public static SymLoadBalancedConfig loadLoadBalancerFromFile(String path) {
        return SymConfigLoader.loadFromFile(path, SymLoadBalancedConfig.class);
    }

    public static SymLoadBalancedConfig loadLoadBalancer(InputStream inputStream) {
        return SymConfigLoader.load(inputStream, SymLoadBalancedConfig.class);
    }

    public static SymConfig loadConfig(String configPath) {
        return SymConfigLoader.loadConfig(configPath, SymConfig.class);
    }

    public static <T extends SymConfig> T loadConfig(String configPath, Class<T> clazz) throws NoConfigException {
        T config;
        String externalUrlPath;
        if (!configPath.startsWith(File.separator)) {
            configPath = File.separator + configPath;
        }
        if (new File(externalUrlPath = System.getProperty("user.dir") + configPath).exists()) {
            config = SymConfigLoader.loadFromFile(externalUrlPath, clazz);
        } else {
            InputStream is = SymConfigLoader.class.getResourceAsStream(configPath);
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(configPath);
            }
            config = SymConfigLoader.load(is, clazz);
        }
        if (config == null) {
            throw new NoConfigException(String.format("Unable to load config from: %s", configPath));
        }
        return config;
    }

    public static SymLoadBalancedConfig loadLoadBalancerConfig(String configPath) {
        return SymConfigLoader.loadConfig(configPath, SymLoadBalancedConfig.class);
    }
}

