/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import configuration.LoadBalancing;
import configuration.SymConfig;
import exceptions.SymClientException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.ws.rs.core.Response;
import model.AgentInfo;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.HttpClientBuilderHelper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SymLoadBalancedConfig
extends SymConfig {
    private static final Logger logger = LoggerFactory.getLogger(SymLoadBalancedConfig.class);
    private LoadBalancing loadBalancing;
    private List<String> agentServers = Collections.emptyList();
    private int currentAgentIndex = -1;
    private String actualAgentHost = null;
    private int actualAgentPort = -1;

    @Override
    public String getAgentHost() {
        boolean isSticky = this.loadBalancing.isStickySessions();
        switch (this.loadBalancing.getMethod()) {
            case random: {
                if (this.currentAgentIndex == -1 || !isSticky) {
                    this.rotateAgent();
                    logger.info("Returning random agent index #{}: {}", (Object)this.currentAgentIndex, (Object)this.agentServers.get(this.currentAgentIndex));
                }
                return this.agentServers.get(this.currentAgentIndex);
            }
            case roundrobin: {
                if (this.currentAgentIndex == -1) {
                    ++this.currentAgentIndex;
                }
                String roundRobinAgentHost = this.agentServers.get(this.currentAgentIndex);
                logger.info("Returning round-robin agent index #{}: {}", (Object)this.currentAgentIndex, (Object)roundRobinAgentHost);
                if (!isSticky) {
                    this.rotateAgent();
                }
                return roundRobinAgentHost;
            }
            case external: {
                if (this.actualAgentHost == null || !isSticky) {
                    logger.info("Retrieving actual agent hostname..");
                    this.rotateAgent();
                }
                logger.info("Actual agent host: {}", (Object)this.actualAgentHost);
                return this.actualAgentHost;
            }
        }
        return super.getAgentHost();
    }

    public void rotateAgent() {
        String newAgent = null;
        switch (this.loadBalancing.getMethod()) {
            case random: {
                this.currentAgentIndex = ThreadLocalRandom.current().nextInt(0, this.agentServers.size());
                newAgent = this.agentServers.get(this.currentAgentIndex);
                break;
            }
            case roundrobin: {
                if (++this.currentAgentIndex == this.agentServers.size()) {
                    this.currentAgentIndex = 0;
                }
                newAgent = this.agentServers.get(this.currentAgentIndex);
                break;
            }
            case external: {
                if (this.agentServers.size() != 1) {
                    throw new SymClientException("Load balancing configuration with method \"external\" must contain only one agent server");
                }
                newAgent = this.actualAgentHost = this.getActualAgentHost(this.agentServers.get(0));
                break;
            }
        }
        logger.info("Agent rotated to: {}", newAgent);
    }

    protected String getActualAgentHost(String externalLoadBalancerUrl) {
        String uri = "https://" + externalLoadBalancerUrl;
        Response response = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(this).build().target(uri).path("/agent/v1/info").request(new String[]{"application/json"}).get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            logger.error("Unable to get actual Agent hostname, cause : {}", (Object)response);
            return null;
        }
        String agentServerFqdn = ((AgentInfo)response.readEntity(AgentInfo.class)).getServerFqdn();
        logger.debug("Agent FQDN={}", (Object)agentServerFqdn);
        return agentServerFqdn;
    }

    public void cloneAttributes(SymConfig config) {
        try {
            BeanUtils.copyProperties((Object)this, (Object)config);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error("Unable to copy properties from " + config + " to this.", (Throwable)e);
        }
    }

    public LoadBalancing getLoadBalancing() {
        return this.loadBalancing;
    }

    public List<String> getAgentServers() {
        return this.agentServers;
    }

    public int getCurrentAgentIndex() {
        return this.currentAgentIndex;
    }

    public String getActualAgentHost() {
        return this.actualAgentHost;
    }

    public int getActualAgentPort() {
        return this.actualAgentPort;
    }

    public void setLoadBalancing(LoadBalancing loadBalancing) {
        this.loadBalancing = loadBalancing;
    }

    public void setAgentServers(List<String> agentServers) {
        this.agentServers = agentServers;
    }

    public void setCurrentAgentIndex(int currentAgentIndex) {
        this.currentAgentIndex = currentAgentIndex;
    }

    public void setActualAgentHost(String actualAgentHost) {
        this.actualAgentHost = actualAgentHost;
    }

    public void setActualAgentPort(int actualAgentPort) {
        this.actualAgentPort = actualAgentPort;
    }
}

